/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: CommandEvent.java,v 1.3 2004/12/12 05:29:19 pietschy Exp $
 */

package org.pietschy.command;

import java.util.EventObject;

/**
 * Fired both before and after a command executes.
 * @see ActionCommand
 * @see ActionCommand#addCommandListener
 */
public class
CommandEvent
extends EventObject
{

   /**
    * Constructs a new event for the specified {@link Command}.
    * @param source the {@link Command} that is being executed.
    */
   public CommandEvent(Command source)
   {
      super(source);
   }

   /**
    * Gets the {@link Command} being executed.
    * @return the {@link Command} being executed.
    */
   public ActionCommand getCommand()
   {
      return (ActionCommand) source;
   }
}
