//LabPlot : Graph4D.h

#ifndef GRAPH4D_H
#define GRAPH4D_H

#include <qtextstream.h>
#include <qprogressdialog.h>
#include "Graph.h"
#include "LRange.h"
#include "Point4D.h"

class Graph4D: public Graph
{
public:
	Graph4D(QString n=QString(""), QString l=QString(""), LRange r[4]=0, LSource src=SFUNCTION, PType t=P2D, 
		Style *st=0, Symbol *sy=0, Point4D *p=0, int nr=0, bool ty=0, bool s=true);
	~Graph4D();
	Graph4D *Clone();		// clone this graph
	Point4D *Data() { return ptr; }
	void setData(Point4D *data) { ptr = data; }
	LRange Range(int i) { return range[i]; }
	void setRange(LRange r[4]) { range[0]=r[0];range[1]=r[1];range[2]=r[2];range[3]=r[3]; }
	bool GType() { return gtype; }
	void setGType(bool t) { gtype = t; }
	void save(QTextStream *t, QProgressDialog *progress);
	void open(QTextStream *t, int version, QProgressDialog *progress);
	void saveXML(QDomDocument doc, QDomElement graphtag);
	void openXML(QDomNode node);
	QStringList Info();
	LRange ErrorDXRange();
	LRange ErrorDYRange();
private:
	LRange range[4];
	bool gtype;						// 0 : x-y-dx-dy, 1: x-y-dy1-dy2
	Point4D *ptr;
};

#endif // GRAPH4D_H
