//LabPlot : PlotPolar.h

#ifndef PLOTPOLAR_H
#define PLOTPOLAR_H

#include "Plot.h"

class PlotPolar:public Plot {
public:
	PlotPolar(Worksheet *p);
	~PlotPolar();
	QStringList Info();
	Axis *getAxis(int i) { return &axis[i]; }
	void saveAxes(QTextStream *t);
	void openAxes(QTextStream *t,int version);
	void saveXML(QDomDocument doc, QDomElement plottag);
	void openXML(QDomElement e);
	void draw(QPainter* p,int w, int h);
	void drawCurves(QPainter* p, int w, int h);
	void setBorder(int, bool) {}
	void setRange(LRange* r,int i) {range[i]=*r;}
	void setActRange(LRange* r,int i) {actrange[i]=*r;}
	void setRanges(LRange* r) {range[0]=r[0];range[1]=r[1];}
	void setActRanges(LRange* r) {actrange[0]=r[0];actrange[1]=r[1];}
private:
	Axis axis[2];		// phi,r
};

#endif // PLOTPOLAR_H
