//LabPlot : GraphL.h

#ifndef GRAPHL_H
#define GRAPHL_H

#include <qpixmap.h>
#include <qtextstream.h>
#include <qprogressdialog.h>
#include "Graph.h"
#include "PointL.h"

class GraphL: public Graph
{
public:
	GraphL(QString n="", QString l="", LRange r=0, LSource src=SFUNCTION, PType t=PSURFACE, Style *st=0, 
		Symbol *sy=0, PointL *p=0, int nr=0, bool s=true);
	~GraphL();
	GraphL *Clone();		// clone this graph
	LRange Range() { return range; }
	void setRange(LRange r) { range=r; }
	PointL *Data() { return ptr; }
	void setData(PointL *data) { ptr = data; }
	QStringList Info();
	void save(QTextStream *t, QProgressDialog *progress);
	void open(QTextStream *t, int version, QProgressDialog *progress);
	void saveXML(QDomDocument doc, QDomElement graphtag);
	void openXML(QDomNode node);
private:
	PointL *ptr;
	LRange range;
};

#endif // GRAPHL_H
