//LabPlot : ImportDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>
#include <qlabel.h>
#include <qhbox.h>
#include <qfiledialog.h>
#include <qprogressdialog.h>
#include <klocale.h>
#include <kdebug.h>
#include <kfilterdev.h>
#include <kmessagebox.h>
#include "ImportDialog.h"
#include "FilterCDF.h"
#include "FilterNETCDF.h"
#include "FilterAUDIOFILE.h"
#include "FilterMAGICK.h"
#include "defs.h"

using namespace std;

#define MAX_POINTS 1000000

/* Dialog for importing data into spreadsheet*/
ImportDialog::ImportDialog(MainWin *mw, QString filename, const char *name)
	: Dialog(0, name), mw(mw)
{
	kdDebug()<<"ImportDialog::ImportDialog()"<<endl;
	setCaption(i18n("Import Data"));
	
	QHBox *hb = new QHBox(vbox);
	filele = new KLineEdit(filename,hb);
	KPushButton *newFile = new KPushButton(i18n("Browse"),hb);
	QObject::connect(newFile,SIGNAL(clicked()),SLOT(selectFile()));

	hb = new QHBox(vbox);
	KPushButton *infopb = new KPushButton(i18n("File Info"),hb);
	infopb->setMaximumWidth(100);
	QObject::connect(infopb,SIGNAL(clicked()),SLOT(fileInfo()));

	hb = new QHBox(vbox);
	new QLabel(i18n("separating character : "),hb);
	readsc = new KLineEdit(i18n("auto"),hb);
	readsc->setMaximumWidth(100);
	hb = new QHBox(vbox);
	new QLabel(i18n("comment character : "),hb);
	commle = new KLineEdit(i18n("#"),hb);
	commle->setMaximumWidth(100);
	hb = new QHBox(vbox);
	new QLabel(i18n("Start Row : "),hb);
	startrow = new KLineEdit("1",hb);
	startrow->setValidator(new QIntValidator(startrow));
	new QLabel(i18n(" End Row : "),hb);
	endrow = new KLineEdit(i18n("END"),hb);

	QObject::connect(ok,SIGNAL(clicked()),SLOT(OK()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(agree()));
	QObject::connect(cancel,SIGNAL(clicked()),SLOT(accept()));

	// gbox > vbox here !
	setMinimumWidth(2*vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void ImportDialog::selectFile() {
	QStringList f = QFileDialog::getOpenFileNames(QString(""),QString(""), this );
	if (! f.isEmpty() )
		filele->setText(f.join(";"));
}

int ImportDialog::agree() {
	// TODO : see DataDialog::addData()
	QStringList fns = QStringList::split(";",filele->text());
	 for ( QStringList::Iterator it = fns.begin(); it != fns.end(); ++it ) {
		QString filename = *it;
		kdDebug()<<"Opening "<<filename<<endl;

		Spreadsheet *s=0;
		if(it==fns.begin())
			s = mw->activeSpreadsheet();
	
		if(!s) { 
			s = mw->newSpreadsheet();
//			kdDebug()<<"No active spreadsheet. Adding a new one."<<endl;
		}

		QTable *table = s->Table();

		if (!filename.isEmpty()) {
			QIODevice *file = KFilterDev::deviceForFile(filename,QString::null,TRUE);
			if(file==0) file = new QFile(filename);
	
			// TODO : use ImageMagick too
			FilterMAGICK mf = FilterMAGICK(filename);
			
			// reading image
			QString format;
	#ifdef HAVE_MAGICK
			if (((format = QString(QImageIO::imageFormat(filename))) != 0 ) || mf.fileOK()) {
	#else
			if ((format = QString(QImageIO::imageFormat(filename))) != 0) {
	#endif
				QPixmap pm;
	#ifdef HAVE_MAGICK
				if(mf.fileOK())
					pm = mf.Pixmap();
				else
	#endif
					pm.load(filename);
				
				QImage image = pm.convertToImage();
				int width = image.width();
				int height = image.height();
				kdDebug() <<" Width/Height : "<<width<<' '<<height<<endl;
				kdDebug() <<" Depth : "<<image.depth()<<endl;
				
				table->setNumCols(width);
				table->setNumRows(height);
				
				for (int i=0;i<width;i++) {
					for (int j=0;j<height;j++) {
						table->setText(j,i,QString::number(qGray(image.pixel(i,j))));
					}
				}
				table->horizontalHeader()->setLabel( 0, QString( "A {double} [Y]" ) );
			}
			else if ( file->open( IO_ReadOnly )) {		// reading normal data (not image)
				int startRow = startrow->text().toInt()-1;
				int endRow;
				if(endrow->text() == i18n("END"))
					endRow = MAX_POINTS;
				else
					endRow = endrow->text().toInt()-1;
				
				QTextStream t(file);
				
				FilterAUDIOFILE auf = FilterAUDIOFILE(filename);
				FilterNETCDF ncf = FilterNETCDF(filename);
				FilterCDF cdf = FilterCDF(filename);
	
				if (auf.fileOK()) {		// audiofile file
					double *data = auf.Data();
					table->setNumRows(auf.frameCount());
					table->setNumCols(auf.channelCount()+1);
					
					QProgressDialog progress( "Reading data ...", "Cancel", auf.frameCount(), this, "progress", TRUE );
					for (int i=startRow;i<auf.frameCount();i++) {
						if(i%1000 == 0) progress.setProgress(i);
						qApp->processEvents();
						table->setText(i,0,QString::number(i/auf.sampleRate()));
						if(auf.channelCount() == 1) 
							table->setText(i,1,QString::number(data[i]));
						else if (auf.channelCount() == 2) {
							table->setText(i,1,QString::number(data[2*i]));
							table->setText(i,2,QString::number(data[2*i+1]));
						}
						if (i>endRow)
							break;
					}
				}
				else if (ncf.fileOK()) {		// netcdf file
					table->setNumCols(ncf.NVars());
	
					//QProgressDialog progress( "Reading data ...", "Cancel", ncf.VarLen(xname), this, "progress", TRUE );
					kdDebug()<<"Reading NETCDF data"<<endl;
					kdDebug()<<" nvars = "<<ncf.NVars()<<endl;
					for (int j=startRow;j<ncf.NVars();j++) {
						QString name = ncf.VarName(j);
						int rows = ncf.VarLen(name);
						kdDebug()<<" var / varid / len = "<<name<<' '<<j<<' '<<rows<<endl;
	
						// TODO : BUG : set column label to name
						s->setColumnTitle( j, name );
	
						if (table->numRows()<rows)
							table->setNumRows(rows);
						for (int i=0;i<rows;i++) {
							//if(i%1000 == 0) progress.setProgress(i);
							table->setText(i,j,QString::number(ncf.Data(name,i)));
						}
						if (j>endRow)
							break;
					}
				}
	#ifdef HAVE_CDF
				else if (cdf.fileOK()) {		// cdf file
					table->setNumCols(cdf.NVars());
					table->setNumRows(cdf.MaxRec());
					
					QProgressDialog progress( "Reading data ...", "Cancel", cdf.MaxRec(), this, "progress", TRUE );
					kdDebug()<<"Reading CDF data"<<endl;
					kdDebug()<<" nvars = "<<cdf.NVars()<<endl;
					for (int j=startRow;j<cdf.NVars();j++) {
						QString name = cdf.VarName(j);
						int rows = cdf.VarLen(name);
						kdDebug()<<" var / varid / len = "<<name<<' '<<j<<' '<<rows<<endl;
	
						// TODO : BUG : set column label to name
						s->setColumnTitle( j, name );
	
						for (int i=0;i<rows;i++) {
							if(i%1000 == 0) progress.setProgress(i);
							table->setText(i,j,QString::number(cdf.Data(name,i)));
						}
						if (j>endRow)
							break;
					}
				}
	#endif
				else {
					QProgressDialog progress( "Reading data ...", "Cancel", file->size(),this, "progress", TRUE );
					int row=0;
					table->setNumCols(1);		// set initial number of cols
					while (!t.eof()) {
						if (row%1000==0) {
							progress.setProgress(file->at() );
							table->setNumRows(row+1000);
						}
						qApp->processEvents();

						while(row<startRow) {
							t.readLine();
							row++;
						}

						QString line = t.readLine();
	
						line = line.simplifyWhiteSpace();
						// ignore comment lines
						if(line.find(QRegExp(commle->text()))==0)
							continue;
						
						QStringList oneline;
						if (readsc->text() == i18n("auto"))
							oneline = QStringList::split(' ', line );
						else
							oneline = QStringList::split(readsc->text().at(0), line );
	
						if(oneline.count() > (unsigned int) table->numCols())
							table->setNumCols(oneline.count());
						
						// handle empty lines correct
						if((*oneline.begin()).length()==0)
							continue;
	
						int j=0;
						for ( QStringList::Iterator it = oneline.begin();it != oneline.end(); ++it ) {
							table->setText(row-startRow,j,(*it));
							j++;
						}
					
						row++;
						if ( progress.wasCancelled() )
							return 1;
						if (row>endRow)
							break;
					}
				
					table->setNumRows(row-startRow);
				}
			}
			else {
				KMessageBox::error(this, i18n("Sorry. Could not open specified data file for reading!"));
				return 2;
			}
			
			// set label for all columns
			for (int i=1;i<table->numCols();i++) {
				if(i<26)
					table->horizontalHeader()->setLabel( i, QChar(i+65)+QString( " {double} [Y]" ) );
				else
					table->horizontalHeader()->setLabel( i, QChar(84)+QString( " {double} [Y]" ) );
			}
		}
	}
		
	return 0;
}
