//LabPlot : ConvolutionListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "ConvolutionListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_fft_real.h>
#include <gsl/gsl_fft_halfcomplex.h>
#endif

inline int MAX(int x,int y) {if (x>y) return x; else return y;}

ConvolutionListDialog::ConvolutionListDialog(Worksheet *p, Spreadsheet *s, const char *name)
	: ListDialog(p, s, name)
{
	setCaption(i18n("Convolution Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);
	
	QHBox *hb = new QHBox(tab1);
	
	type = new KComboBox(hb);
	QStringList tlist;
	tlist << i18n("convolute") << i18n("deconvolute");
	type->insertStringList(tlist);
	type->setCurrentItem(0);
	
	hb = new QHBox(tab1);
	new QLabel(i18n("set "),hb);
	set1le = new KLineEdit(QString("1"),hb);
	new QLabel(i18n("with set "),hb);
	set2le = new KLineEdit(QString("2"),hb);
	
	// TODO : select gsl or fftw

	hb = new QHBox(tab1);
	new QLabel(i18n("x-values : "),hb);
	xvalue = new KComboBox(hb);
	QStringList vlist;
	vlist << i18n("index") << i18n("signal");
	xvalue->insertStringList(vlist);
	xvalue->setCurrentItem(0);
	
	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void ConvolutionListDialog::apply_clicked() {
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->getNumber()==0)
		return;

	unsigned int item1 = set1le->text().toInt()-1;
	unsigned int item2 = set2le->text().toInt()-1;

	if (item1 > gl->getNumber() || item2 > gl->getNumber()) {
		KMessageBox::error(this, i18n("Sorry. Can not find selected data sets!"));
		return;
	}
	
	GRAPHType s1 = gl->getStruct(item1);
	GRAPHType s2 = gl->getStruct(item2);

	if (s1 == GRAPH2D && s2 == GRAPH2D ) {
		Graph2D *g1 = gl->getGraph2D(item1);
		Graph2D *g2 = gl->getGraph2D(item2);
		int nr1=g1->Number(), nr2 =g2->Number() ;

		int signr, resnr;
		Point *sigdata, *resdata;	// data
		if (nr1>nr2) {
			signr = g1->Number();
			resnr = g2->Number();
			sigdata = g1->Data();
			resdata = g2->Data();
		}
		else {
			signr = g2->Number();
			resnr = g1->Number();
			sigdata = g2->Data();
			resdata = g1->Data();
		}
		
		double *dsig = new double[signr], *dres = new double[resnr];		// y data values
		for (int i=0;i<signr;i++)
			dsig[i]=sigdata[i].Y();
		for (int i=0;i<resnr;i++)
			dres[i]=resdata[i].Y();
		
		int nr = signr+resnr/2;		// tmp number of points

		// round to nearest factor of two (not needed when using mixed radix fft's !)
		int nrnew = 64;
		while(nrnew<nr && nrnew>0)
			nrnew *= 2;
		nr=nrnew;
		
		// TODO : convolute here using fftw too (see fit list dialog)
#ifdef HAVE_GSL
		double *sig = new double[nr], *res = new double[nr];
		
		memset(res,0,nr*sizeof(double));
		for (int i=0;i<resnr/2;i++) {
			res[i] = dres[resnr/2+i];
			res[nr-resnr/2+i] = dres[i];
		}
		
		if(resnr/2%2==1)
			res[resnr/2]=dres[resnr];
			
		memset(sig,0,nr*sizeof(double));
		memcpy(sig,dsig,signr*sizeof(double));
	
		// calculate ffts
		gsl_fft_real_radix2_transform(res,1,nr);
		gsl_fft_real_radix2_transform(sig,1,nr);
		
		double re, im, size;
		int t = type->currentItem();	// 0: convolve, 1: deconvolve
		// multiply/divide both ffts
		for (int i=0;i<nr/2;i++) {
			if(i==0 || i==nr/2-1) {
				if(t == 0)
					res[i] = res[i]*sig[i];
				else 
					res[i] = sig[i]/res[i];
			}
			else {
				if(t == 0) {
					re = res[i]*sig[i]-res[nr-i]*sig[nr-i];
					im = res[i]*sig[nr-i]+res[nr-i]*sig[i];
				}
				else {
					size = res[i]*res[i]+res[nr-i]*res[nr-i];
					re = res[i]*sig[i]+res[nr-i]*sig[nr-i];
					im = res[i]*sig[nr-i]-res[nr-i]*sig[i];
					re /= size;
					im /= size;
				}
				
				res[i] = re;
				res[nr-i] = im;
			}
		}
		// inverse fft
		gsl_fft_halfcomplex_radix2_inverse(res,1,nr);
		
		double *conv = new double[signr];
		memcpy(conv,res,signr*sizeof(double));
		
		free(sig);free(res);
		
		// make new data set from conv[signr];
		Point *ptr = new Point[signr];
		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<signr;i++) {
			double x=0;
			switch(xvalue->currentItem()) {
			case 0:
				x=i;break;
			case 1:
				x=sigdata[i].X();break;
			}
			double y = conv[i];
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
		}

		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun;
		if (t==0)
			fun = QString(i18n("convolution of ")+g1->Label()+i18n(" with ")+g2->Label());
		else
			fun = QString(i18n("deconvolution of ")+g1->Label()+i18n(" with ")+g2->Label());
			
		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
		
		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,signr);
		p->addGraph2D(ng);
#else
		KMessageBox::error(this, i18n("Sorry. Your installation doesn't support the GSL!"));
#endif
	}
	else if (s1 == GRAPH3D) {
		// TODO
	}
	else if (s1 == GRAPHM) {
		// TODO
	}

	updateList();
}
