#include <stdio.h>
#include <string.h>

#include <orbit/orbit.h>
#include <libbonobo.h>

#include "e-mail-remote-glue.h"
#include "e-mail-remote-glue-utils.h"
#include "e-mail-remote-glue-folderinfo.h"
#include "e-mail-remote-glue-storeinfo.h"

static void e_mail_remote_glue_storeinfo_class_init (EMailRemoteGlueStoreInfoClass *klass);
static void e_mail_remote_glue_storeinfo_init (EMailRemoteGlueStoreInfo *comp, EMailRemoteGlueStoreInfoClass *klass);
static void e_mail_remote_glue_storeinfo_finalize (GObject *object);

/*static guint e_mail_remote_signals[LAST_SIGNAL] = { 0 };*/

static GObjectClass *parent_class;

struct _EMailRemoteGlueStoreInfoPrivate {
  char* name;
  char* uid;
  Bonobo_Unknown store; /* Evolution_Mail_Store */
  EMailRemoteGlue* sess;
};

/**
 * e_mail_remote_glue_storeinfo_get_type:
 *
 * Registers the #EMailRemoteGlueStoreInfo class if necessary, and returns the type ID
 * associated to it.
 *
 * Return value: The type ID of the #EMailRemoteGlueStoreInfo class.
 **/
GType
e_mail_remote_glue_storeinfo_get_type (void)
{
  static GType e_mail_remote_glue_storeinfo_type = 0;

  if (!e_mail_remote_glue_storeinfo_type) {
    static GTypeInfo info = {
      sizeof (EMailRemoteGlueStoreInfoClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) e_mail_remote_glue_storeinfo_class_init,
      NULL, NULL,
      sizeof (EMailRemoteGlueStoreInfo),
      0,
      (GInstanceInitFunc) e_mail_remote_glue_storeinfo_init
    };
    e_mail_remote_glue_storeinfo_type = g_type_register_static (G_TYPE_OBJECT, "EMailRemoteGlueStoreInfo", &info, 0);
  }

  return e_mail_remote_glue_storeinfo_type;
}

/* Class initialization function for the calendar-glue object */
static void
e_mail_remote_glue_storeinfo_class_init (EMailRemoteGlueStoreInfoClass *klass)
{
  GObjectClass *object_class;

  object_class = (GObjectClass *) klass;

  parent_class = g_type_class_peek_parent (klass);

  object_class->finalize = e_mail_remote_glue_storeinfo_finalize;
}

/* Object initialization function for the calendar-glue object */
static void
e_mail_remote_glue_storeinfo_init (EMailRemoteGlueStoreInfo *emrg_sinfo, EMailRemoteGlueStoreInfoClass *klass)
{  
  emrg_sinfo->priv = g_new0 (EMailRemoteGlueStoreInfoPrivate, 1);
  emrg_sinfo->priv->sess = NULL;
}

/**
 * e_mail_remote_glue_storeinfo_new:
 *
 * Creates a new empty calendar-glue component object.  
 *
 * Return value: A newly-created calendar-glue component object.
 **/
EMailRemoteGlueStoreInfo *
e_mail_remote_glue_storeinfo_new (void)
{
  return E_MAIL_REMOTE_GLUE_STOREINFO (g_object_new (E_TYPE_MAIL_REMOTE_GLUE_STOREINFO, NULL));
}

/* Finalize handler for the calendar-glue component object */
static void
e_mail_remote_glue_storeinfo_finalize (GObject *object)
{
  EMailRemoteGlueStoreInfo *sinfo;
  EMailRemoteGlueStoreInfoPrivate *priv;

  g_return_if_fail (object != NULL);
  g_return_if_fail (E_IS_MAIL_REMOTE_GLUE_STOREINFO (object));

  sinfo = E_MAIL_REMOTE_GLUE_STOREINFO (object);
  priv = sinfo->priv;

  if (priv) {
    g_free (priv->name);
    g_free (priv->uid);
    bonobo_object_release_unref (priv->store, NULL);
    
    if (priv->sess)
      g_object_unref (priv->sess);

    priv->name = NULL;
    priv->uid = NULL;
    priv->store = NULL;
    priv->sess = NULL;

    g_free (priv);
    sinfo->priv = NULL;
  }
  
  if (G_OBJECT_CLASS (parent_class)->finalize)
    (* G_OBJECT_CLASS (parent_class)->finalize) (object);
}

EMailRemoteGlueStoreInfo*
e_mail_remote_glue_storeinfo_new_clone (EMailRemoteGlueStoreInfo* info)
{
  CORBA_Environment ev = { 0 };
  EMailRemoteGlueStoreInfo* emrg_sinfo = e_mail_remote_glue_storeinfo_new ();
  EMailRemoteGlueStoreInfoPrivate* priv = emrg_sinfo->priv;

  priv->name = g_strdup (info->priv->name);
  priv->uid = g_strdup (info->priv->uid);
  priv->store = bonobo_object_dup_ref (info->priv->store, &ev);
  priv->sess = info->priv->sess;
  g_object_ref (info->priv->sess);
  /* FIXME: Error handling */
  
  return emrg_sinfo;
}


EMailRemoteGlueStoreInfo*
e_mail_remote_glue_storeinfo_new_from_EMStoreInfo (Evolution_Mail_StoreInfo info)
{
  EMailRemoteGlueStoreInfo* emrg_sinfo = e_mail_remote_glue_storeinfo_new ();
  EMailRemoteGlueStoreInfoPrivate* priv = emrg_sinfo->priv;
  CORBA_Environment ev = { 0 };

  priv->name = g_strdup (info.name);
  priv->uid = g_strdup (info.uid);
  priv->store = bonobo_object_dup_ref (info.store, &ev);
  /* FIXME: Error handling */
  
  return emrg_sinfo;
}

void
e_mail_remote_glue_storeinfo_set_session_object (EMailRemoteGlueStoreInfo* sinfo, 
						 EMailRemoteGlue* sess)
{
  g_return_if_fail (sinfo != NULL);
  g_return_if_fail (sinfo->priv != NULL);

  sinfo->priv->sess = sess;
  g_object_ref (sess);
}

char* 
e_mail_remote_glue_storeinfo_peek_uid (EMailRemoteGlueStoreInfo* sinfo)
{
  g_return_val_if_fail (sinfo != NULL, NULL);
  g_return_val_if_fail (sinfo->priv != NULL, NULL);

  return sinfo->priv->uid;
}

char* 
e_mail_remote_glue_storeinfo_peek_name (EMailRemoteGlueStoreInfo* sinfo)
{
  g_return_val_if_fail (sinfo != NULL, NULL);
  g_return_val_if_fail (sinfo->priv != NULL, NULL);

  return sinfo->priv->name;
}

Evolution_Mail_Store 
e_mail_remote_glue_storeinfo_peek_EMStore (EMailRemoteGlueStoreInfo* sinfo)
{
  g_return_val_if_fail (sinfo != NULL, NULL);
  g_return_val_if_fail (sinfo->priv != NULL, NULL);

  return sinfo->priv->store;
}

GSList* 
e_mail_remote_glue_storeinfo_get_folders (EMailRemoteGlueStoreInfo* sinfo)
{
  EMailRemoteGlueStoreInfoPrivate* priv = sinfo->priv;
  EvolutionMailFolderListener* listener_folder = NULL;
  Evolution_Mail_FolderInfos* folders;
  CORBA_Environment ev = { 0 };
  GSList* emrg_finfo_list = NULL;
  int i;

  listener_folder = e_mail_remote_glue_peek_folder_listener (priv->sess);

  folders = Evolution_Mail_Store_getFolders (priv->store, "",
					       bonobo_object_corba_objref ((BonoboObject *)listener_folder),
					       &ev);
  if (ev._major != CORBA_NO_EXCEPTION) {
    e_mail_exception_dump (&ev, "getting stores");
    return NULL;
  }  

  for (i = 0; i < folders->_length; i++) {
    EMailRemoteGlueFolderInfo* emrg_finfo = e_mail_remote_glue_folderinfo_new_from_EMFolderInfo (folders->_buffer[i]);
    emrg_finfo_list = g_slist_prepend (emrg_finfo_list, emrg_finfo);
  }

  if (emrg_finfo_list)
    emrg_finfo_list = g_slist_reverse (emrg_finfo_list);

  return emrg_finfo_list;

}
