/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * parser_ds_def.c
 *
 * parser model definition file
 *
 */

#include <stdlib.h>

#include "parser_defs.h"
#include "parser.h"
#include "constants.h"
#include "manifold.h"
#include "math_utils.h"
#include <pm.h>
#include <model_headers.h>

int parser_ds_def( double f[], double x[], double p[] )
{
  void* sym_ds = (void*)pm( GET, "Parser.Old_DS", NULL );

  int status = parser_eval(sym_ds, f, x, p);
  if (status != PARSER_OK)
    fprintf(stdout,"parser_ds_def: PARSER ERROR in evaluation.\n");
  return 0;
}

int parser_ds_func( double f[], double x[], double p[] )
{
  void* sym_ds = (void*)pm( GET, "Parser.Old_DS", NULL );

  int status = parser_eval_aux_fn(sym_ds,f,x,p);
  if (status != PARSER_OK)
    fprintf(stdout,"parser_ds_def: PARSER ERROR in evaluation.\n");
  return 0;
}

int parser_ds_jac( double f[], double x[], double p[] )
{
  void* sym_ds = (void*)pm( GET, "Parser.Old_DS", NULL );

  int status = PARSER_OK;

  if (status != PARSER_OK)
    fprintf(stdout,"parser_ds_def: PARSER ERROR in evaluation.\n");
  return 0;
}

int parser_ds_inv( double f[], double x[], double p[] )
{
  void* sym_ds = (void*)pm( GET, "Parser.Old_DS", NULL );

  int status = PARSER_OK;

  if (status != PARSER_OK)
    fprintf(stdout,"parser_ds_def: PARSER ERROR in evaluation.\n");
  return 0;
}


int parser_ds_init( void )
{
  int     i;
  int     status = PARSER_OK;

  void*   ds = NULL;
  void*   old_ds = NULL;
  int     ds_type;

  int     n_varb;
  double* variables;
  double* variable_min;
  double* variable_max;
  double  indep_varb_min;
  double  indep_varb_max;
  char**  variable_names;
  char*   indep_varb_name;

  int     n_param;
  double* parameters;
  double* parameter_min;
  double* parameter_max;
  char**  parameter_names;

  int     n_funct;
  double* funct_min;
  double* funct_max;
  char**  funct_names;

  int     manifold_type;
  int*    periodic_varb;
  double* period_start;
  double* period_end;

  int     mapping_toggle;
  int     inverse_toggle;

  int     (*def_name)()=parser_ds_def;
  int     (*jac_name)()=NULL;
  int     (*aux_func_name)()=parser_ds_func;
  int     (*inv_name)()=NULL;
  int     (*dfdt_name)()=NULL;
  int     (*dfdparam_name)()=NULL;

  char *c_filename = "parser.txt";

  ds_type = *(int*)pm( GET, "Parser.Mapping_Flag", NULL);

  /* ds is already built and is a valid dynamical system */
  /* replace old_ds with ds */
  old_ds = (void*)pm( GET, "Parser.Old_DS", NULL );
  ds = (void*)pm( GET, "Parser.New_DS", NULL );
  parser_destroy_ds(old_ds);
  pm(INIT, "Parser.Old_DS",
     INIT, "Parser.New_DS",
     PUT, "Parser.Old_DS", ds,
     PUT, "Parser.New_DS_Status", 0,
     NULL);
 
  /*
  parser_print_ds(stdout,ds); 
  */

  if( ds_type ) { 
    /*
     * mapping 
       fprintf(stdout,"parser_ds_init: model is a mapping\n");
     */
    mapping_toggle = TRUE;
    inverse_toggle = FALSE;
    indep_varb_name = INDEP_MAP;
    indep_varb_min = INDEP_MIN_MAP;
    indep_varb_max = INDEP_MAX_MAP;
    manifold_type = EUCLIDEAN;
  }
  else {
    /* 
     * vector field 
       fprintf(stdout,"parser_ds_init: model is a vector field\n");
     */
    mapping_toggle = FALSE;
    inverse_toggle = FALSE;
    indep_varb_name = INDEP_VF;
    indep_varb_min = INDEP_MIN_VF;
    indep_varb_max = INDEP_MAX_VF;
    manifold_type = EUCLIDEAN;
  }

  n_varb = parser_get_n_vars(ds);
  variable_names = (char **) calloc(n_varb, sizeof(char *));
  variables = dvector(0, n_varb-1);
  variable_min = dvector(0, n_varb-1);
  variable_max = dvector(0, n_varb-1);
  periodic_varb = ivector(0, n_varb-1);
  period_start = dvector(0, n_varb-1);
  period_end = dvector(0, n_varb-1);

  for (i=0; i<n_varb; i++)
    {
      variable_names[i] = parser_get_var_name(ds,i);
      variables[i] = ds_type ? VAR_IC_MAP : VAR_IC_VF;
      parser_get_var_ic(ds,i,variables+i);
      variable_min[i] = ds_type ? VAR_MIN_MAP : VAR_MIN_VF;
      variable_max[i] = ds_type ? VAR_MAX_MAP : VAR_MAX_VF;
      parser_get_var_range(ds,i,variable_min+i,variable_max+i);
      periodic_varb[i] = FALSE;
      period_start[i] = 0.0;
      period_end[i] = 0.0;
      if (parser_get_var_periodic(ds,i,period_start+i,period_end+i)==PARSER_OK)
	{
	  periodic_varb[i] = TRUE;
	  manifold_type = PERIODIC;
	}
    }

  n_param = parser_get_n_pars(ds);
  parameter_names = (char **) calloc(n_param, sizeof(char *));
  parameters = dvector(0, n_param-1);
  parameter_min = dvector(0, n_param-1);
  parameter_max = dvector(0, n_param-1);
  for (i=0; i<n_param; i++)
    {
      parameter_names[i] = parser_get_par_name(ds, i);
      parameters[i] = ds_type ? PAR_IC_MAP : PAR_IC_VF;
      parser_get_param_ic(ds,i,parameters+i);
      parameter_min[i] = ds_type ? PAR_MIN_MAP : PAR_MIN_VF;
      parameter_max[i] = ds_type ? PAR_MAX_MAP : PAR_MAX_VF;
      parser_get_param_range(ds,i,parameter_min+i,parameter_max+i);
    }

  n_funct = parser_get_n_aux_fns(ds);
  funct_names = (char **) calloc(n_funct, sizeof(char *));
  funct_min = dvector(0, n_funct-1);
  funct_max = dvector(0, n_funct-1);
  for (i=0; i<n_funct; i++)
    {
      funct_names[i] = parser_get_aux_fn_name(ds, i);
      funct_min[i] = ds_type ? FN_MIN_MAP : FN_MIN_VF;
      funct_max[i] = ds_type ? FN_MAX_MAP : FN_MAX_VF;
      parser_get_aux_fn_range(ds,i,funct_min+i,funct_max+i);
    }

#include <ds_define.c>

  free(variable_names);
  free(parameter_names);
  free(funct_names);
  free_dvector(variables, 0, n_varb-1);
  free_dvector(variable_min, 0, n_varb-1);
  free_dvector(variable_max, 0, n_varb-1);
  free_dvector(parameters, 0, n_param-1);
  free_dvector(parameter_min, 0, n_param-1);
  free_dvector(parameter_max, 0, n_param-1);
  free_dvector(period_start, 0, n_varb-1);
  free_dvector(period_end, 0, n_varb-1);
  free_ivector(periodic_varb, 0, n_varb-1);
  free_dvector(funct_min, 0, n_funct-1);
  free_dvector(funct_max, 0, n_funct-1);

  return status;
}
