/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * selected.c
 */

/*
 * Create SELECTED postmaster object
 */
#include <stdio.h>

#include <constants.h>
#include <defaults.h>
#include <pm.h>
#include <math_utils.h>
#include <utilities.h>
#include <memory.h>
#include <modellib.h>
#include <view.h>

static void copy_final_to_initial(void);
static void sel_compute_functions(void);
static void selected_reset(void);
static void selected_save_pt(void);

static char *SELECT_OBJ_NAME = "Selected";

static char *SELECT[] = {
  "Selected.Varb_Ic", "Selected.Varb_Fc", 
  "Selected.Param_Ic", "Selected.Param_Fc",
  "Selected.Funct_Ic", "Selected.Funct_Fc",
  "Selected.Funct", "Selected.Copy",
  "Selected.Save_Point",
  "Selected.Reset"
  };

typedef enum {
  VARB_IC=0, VARB_FC, PARAM_IC, PARAM_FC, FUNCT_IC, FUNCT_FC, FUNCT_COMP,
  COPY, SAVE_PT, RESET
  } SELECT_t;


void
selected_install()
{

  pm(CREATE_OBJ, SELECT_OBJ_NAME,
     CREATE_ELEM, SELECT[VARB_IC], DBL_LIST,
     CREATE_ELEM, SELECT[VARB_FC], DBL_LIST,
     CREATE_ELEM, SELECT[PARAM_IC], DBL_LIST,
     CREATE_ELEM, SELECT[PARAM_FC], DBL_LIST,
     CREATE_ELEM, SELECT[FUNCT_IC], DBL_LIST,
     CREATE_ELEM, SELECT[FUNCT_FC], DBL_LIST,
     CREATE_ELEM, SELECT[FUNCT_COMP], FNCT,
     CREATE_ELEM, SELECT[COPY], FNCT,
     CREATE_ELEM, SELECT[SAVE_PT], FNCT,
     CREATE_ELEM, SELECT[RESET], FNCT,
     NULL);

  pm(INIT, SELECT[COPY],
     PUT, SELECT[COPY], copy_final_to_initial,
     INIT, SELECT[FUNCT_COMP],
     PUT, SELECT[FUNCT_COMP], sel_compute_functions,
     INIT, SELECT[SAVE_PT],
     PUT, SELECT[SAVE_PT], selected_save_pt,
     INIT, SELECT[RESET],
     PUT, SELECT[RESET], selected_reset,
     NULL);
}

static void
selected_reset()
{
  int dim, i;
  double d;

  dim = *((int *) pm(GET, "Model.Varb_Dim", NULL));;
  pm(INIT, SELECT[VARB_IC], dim,
     INIT, SELECT[VARB_FC], dim,
     NULL);
  for (i=0; i<dim; i++)
    {
      d = *((double *) pm(GET, "Model.Varb_Ic", i, NULL));
      pm(PUT, SELECT[VARB_IC], i, d,
	 PUT, SELECT[VARB_FC], i, d,
	 NULL);
    }
  dim = *((int *) pm(GET, "Model.Param_Dim", NULL));;
  pm(INIT, SELECT[PARAM_IC], dim,
     INIT, SELECT[PARAM_FC], dim,
     NULL);
  for (i=0; i<dim; i++)
    {
      d = *((double *) pm(GET, "Model.Param_Ic", i, NULL));
      pm(PUT, SELECT[PARAM_IC], i, d,
	 PUT, SELECT[PARAM_FC], i, d,
	 NULL);
    }
  dim = *((int *) pm(GET, "Model.Funct_Dim", NULL));;
  pm(INIT, SELECT[FUNCT_IC], dim,
     INIT, SELECT[FUNCT_FC], dim,
     EXEC, SELECT[FUNCT_COMP],
     NULL);
  
}


static void
copy_final_to_initial()
{
  int 		i, n_varb, n_param;
  double 	value;
	
  n_varb = *((int *) pm(GET, "Model.Varb_Dim", NULL));
  n_param = *((int *) pm(GET, "Model.Param_Dim", NULL));
  for (i=0; i<n_varb; i++)
    {
      value = *((double *) pm(GET, SELECT[VARB_FC], i, NULL));
      pm(PUT, SELECT[VARB_IC], i, value, NULL); 
    }
  for (i=0; i<n_param; i++)
    {
      value = *((double *) pm(GET, SELECT[PARAM_FC], i, NULL));
      pm(PUT, SELECT[PARAM_IC], i, value, NULL); 
    }
  pm(EXEC, SELECT[FUNCT_COMP],
     EXEC, "Geomview.Selected",
     NULL);
}

/* sel_compute_functions 
 * 
 * Compute functions for the model. 
 * 
 * Name changed:  8/19/97 BAM 
 */ 
static void
sel_compute_functions()
{
  int vdim, pdim, fdim;
  double *func, *varb, *param;

  fdim = *((int *) pm(GET, "Model.Funct_Dim", NULL)); 
  if (fdim==0) return;

  vdim = *((int *) pm(GET, "Model.Varb_Dim", NULL));
  pdim = *((int *) pm(GET, "Model.Param_Dim", NULL));

  func = dvector(0,fdim-1);
  varb = dvector(0,vdim-1);
  param = dvector(0,pdim-1);

  pm(GET_LIST, "Selected.Varb_Ic", 0, vdim-1, varb, NULL);
  pm(GET_LIST, "Selected.Param_Ic", 0, pdim-1, param, NULL); 
  get_ds_func(func, varb, param);
  pm(PUT_LIST, "Selected.Funct_Ic", 0, fdim-1, func, NULL);

  pm(GET_LIST, "Selected.Varb_Fc", 0, vdim-1, varb, NULL);
  pm(GET_LIST, "Selected.Param_Fc", 0, pdim-1, param, NULL); 
  get_ds_func(func, varb, param);
  pm(PUT_LIST, "Selected.Funct_Fc", 0, fdim-1, func, NULL);
  
  free_dvector(varb,0,vdim-1);
  free_dvector(param,0,pdim-1);
  free_dvector(func,0,fdim-1);
}


/*
 * write point to Selected Point memory object
 */
void
selected_save_pt()
{
  int vdim, pdim, status=0, color[3];
  double *varb, *param;
  memory m;

  /* find dimensions */
  vdim = *((int *) pm(GET, "Model.Varb_Dim", NULL));
  pdim = *((int *) pm(GET, "Model.Param_Dim", NULL));

  /* allocate space and get values */
  varb = dvector(0,vdim-1);
  param = dvector(0,pdim-1);
  pm(GET_LIST, "Selected.Varb_Ic", 0, vdim-1, varb, NULL);
  pm(GET_LIST, "Selected.Param_Ic", 0, pdim-1, param, NULL); 

  /* save to memory object */
  m = (memory) pm(GET, "Memory.Sel_Pt", NULL);
  if (!m) status = -1;
  else {
    color[0] = -1; /* force use of pick color */
    color[1] = *((int *) pm(GET, "Color.Pick_Color_Choice"));
    color[2] = *((int *) pm (GET, "Defaults.Symbol_Index", NULL));
    
    if (!memory_exists_current_flow(m))
      memory_start_new_flow(m, 1, 0, 0, 2, 0, 0);
    status = memory_add_point(m, varb, param, color, NULL, NULL, NULL, NULL);
    if (status == 0) {
      view_plot_mem(m); /* this replots the whole view object - inefficient */
      /* plot_point(varb, param, color[1], color[2]); */
    }

    pm(EXEC, "Memory.Count", NULL);
  }

  if (status) {
    system_mess_proc(1, "selected_save_pt:Cannot save point.");
  }
  
  /* free allocated memory */
  free_dvector(varb, 0, vdim-1);
  free_dvector(param, 0, pdim-1);

}
