/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <stdlib.h>
#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_Glyph
#define _Included_org_freedesktop_cairo_Glyph
#include "org_freedesktop_cairo_Glyph.h"
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_freedesktop_cairo_Glyph
 * Method:    alloc
 * Signature: ()Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Glyph_alloc__
  (JNIEnv *env, jclass cls)
{
	cairo_glyph_t *glyph;
	
	glyph = malloc (sizeof (cairo_glyph_t));
	return getHandleFromPointer(env, glyph);
}

/*
 * Class:     org_freedesktop_cairo_Glyph
 * Method:    alloc
 * Signature: (JDD)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_Glyph_alloc__JDD
  (JNIEnv *env, jclass cls, jlong index, jdouble x, jdouble y)
{
	cairo_glyph_t *glyph;
	
	glyph = malloc (sizeof (cairo_glyph_t));
	glyph->index = index;
	glyph->x = x;
	glyph->y = y;
	return getHandleFromPointer(env, glyph);
}

/*
 * Class:     org_freedesktop_cairo_Glyph
 * Method:    free
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Glyph_free
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_glyph_t *glyph;
	
	glyph = getPointerFromHandle(env, obj);
	free(glyph);
}

/*
 * Class:     org_freedesktop_cairo_Glyph
 * Method:    get_index
 * Signature: (Lorg/gnu/glib/Handle;)J
 */
JNIEXPORT jlong JNICALL Java_org_freedesktop_cairo_Glyph_get_1index
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_glyph_t *glyph = (cairo_glyph_t*)getPointerFromHandle(env, obj);
	return (jlong)glyph->index;
}

/*
 * Class:     org_freedesktop_cairo_Glyph
 * Method:    get_x
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_Glyph_get_1x
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_glyph_t *glyph = (cairo_glyph_t*)getPointerFromHandle(env, obj);
	return (jdouble)glyph->x;
}

/*
 * Class:     org_freedesktop_cairo_Glyph
 * Method:    get_y
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_freedesktop_cairo_Glyph_get_1y
  (JNIEnv *env, jclass cls, jobject obj)
{
	cairo_glyph_t *glyph = (cairo_glyph_t*)getPointerFromHandle(env, obj);
	return (jdouble)glyph->y;
}

/*
 * Class:     org_freedesktop_cairo_Glyph
 * Method:    set_index
 * Signature: (Lorg/gnu/glib/Handle;J)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Glyph_set_1index
  (JNIEnv *env, jclass cls, jobject obj, jlong index)
{
	cairo_glyph_t *glyph;
	
	glyph = getPointerFromHandle(env, obj);
	glyph->index = index;
}

/*
 * Class:     org_freedesktop_cairo_Glyph
 * Method:    set_x
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Glyph_set_1x
  (JNIEnv *env, jclass cls, jobject obj, jdouble x)
{
	cairo_glyph_t *glyph;
	
	glyph = getPointerFromHandle(env, obj);
	glyph->x = x;
}

/*
 * Class:     org_freedesktop_cairo_Glyph
 * Method:    set_y
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_freedesktop_cairo_Glyph_set_1y
  (JNIEnv *env, jclass cls, jobject obj, jdouble y)
{
	cairo_glyph_t *glyph;
	
	glyph = getPointerFromHandle(env, obj);
	glyph->y = y;
}


#ifdef __cplusplus
}
#endif
#endif
