/*
   ArrayUtil, program to check and configure a SmartArray controller
   Copyright (C) 1999  Hugo Trippaers

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
   $Header: /home/cvs/cvsroot/array-util/array_util.c,v 1.11 2001/08/30 12:27:53 spark Exp $
 */

#include <stdio.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <time.h>
#include "images.h"
#include "discover.h"
#include "menubar.h"
#include "interface.h"
#include "array_util.h"
#include "utils.h"

GdkPixmap *icon_ctrl_image;
GdkBitmap *icon_ctrl_bitmap;
GdkPixmap *icon_logdrv_image;
GdkBitmap *icon_logdrv_bitmap;
GdkPixmap *icon_physdrv_image;
GdkBitmap *icon_physdrv_bitmap;
GdkPixmap *icon_error_image;
GdkBitmap *icon_error_bitmap;
GdkPixmap *icon_miniwarn;
GdkBitmap *icon_miniwarn_bm;
GdkPixmap *icon_miniinfo;
GdkBitmap *icon_miniinfo_bm;
GdkPixmap *icon_minierr;
GdkBitmap *icon_minierr_bm;
GdkFont *infofont;

GtkWidget *infotxt;

int ctrls_found_num = 0;
struct controller ctrls_found[8]; /* Max. number of controllers */

const char *statusstr[] = {
        "Logical drive /dev/ida/c%dd%d ok",
        "Logical drive /dev/ida/c%dd%d failed",
        "Logical drive /dev/ida/c%dd%d not configured",
        "Logical drive /dev/ida/c%dd%d using interim recovery mode, %3.2f%% done",
        "Logical drive /dev/ida/c%dd%d ready for recovery operation",
        "Logical drive /dev/ida/c%dd%d is currently recovering, %3.2f%% done",
        "Wrong physical drive was replaced",
        "A physical drive is not properly connected",
        "Hardware is overheating",
        "Hardware has overheated",
        "Logical drive /dev/ida/c%dd%d is currently expanding, %3.2f%% done",
        "Logical drive /dev/ida/c%dd%d is not yet available",
        "Logical drive /dev/ida/c%dd%d is queued for expansion",
};

static gint lastrow=0;

/* Status change event management */
gint 
insert_event(GtkWidget *eventlist, int type, gchar *description) 
{
   gint rownumber;
   gchar *entry[3];
   time_t currenttime;

   rownumber = lastrow++;

   gtk_clist_freeze(GTK_CLIST(eventlist));

   entry[0] = (gchar *) malloc(1024);
/*   entry[1] = (gchar *) malloc(1024); */
   entry[2] = (gchar *) malloc(1024);
   strncpy(entry[0], "", 1024);
   currenttime = time(NULL);
   entry[1] = ctime(&currenttime);
   strncpy(entry[2], description, 1024);

   rownumber = gtk_clist_append(GTK_CLIST(eventlist), entry);
   switch (type) {
     case 0: 
     case 2: 
     case 4: 
     case 10: 
     case 11:
       gtk_clist_set_pixmap(GTK_CLIST(eventlist),rownumber,0,icon_miniinfo, 
	icon_miniinfo_bm);
	break;
     case 3:
     case 5:
     case 7:
     case 9:
       gtk_clist_set_pixmap(GTK_CLIST(eventlist),rownumber,0,icon_miniinfo, 
	icon_miniinfo_bm);
       break;
     case 1:
     case 6:
     case 8:
       gtk_clist_set_pixmap(GTK_CLIST(eventlist),rownumber,0,icon_miniinfo,
        icon_miniinfo_bm);
       break;
     default:
	break;
   }
   
   gtk_clist_thaw(GTK_CLIST(eventlist));
   return rownumber;
}

gint
delete_event (GtkWidget * widget,
	      GdkEvent * event,
	      gpointer data)
{
  g_print ("delete event occurred\n");

  /* Change TRUE to FALSE and the main window will be destroyed with
   * a "delete_event". */

  return (FALSE);
}


/* Another callback */
void
destroy (GtkWidget * widget,
	 gpointer data)
{
  gtk_main_quit ();
}


int
main (int argc,
      char *argv[])
{
  /* main window */
  GtkWidget *window;

  GtkWidget *vbox;
  GtkWidget *controller_tree;
  GtkWidget *statusbar;
  GtkWidget *menubar;
  GtkWidget *quit_item;
  GtkWidget *file_item;
  GtkWidget *file_menu;
  GtkWidget *option_menu;
  GtkWidget *option_item;
  GtkWidget *blink_option;
  GtkWidget *hbox;
  GtkWidget *treewin;
  GtkWidget *eventlist;

  GtkWidget *infotxt_vbar;

  char title[50];
  char buffer[50];


  gtk_init (&argc, &argv);

  window = create_mainwindow();

  strncpy (title, "Array-Util@", 50);
  gethostname((char *)&buffer, 50);
  strcat (title, buffer);
  
  gtk_window_set_title(GTK_WINDOW(window), title);
  
  /* preload some stuff */

  infofont = gdk_font_load ("-*-lucidatypewriter-*-*-*-*-12-*-*-*-m-*-*-*");
  /* done preloading */

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (destroy), NULL);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);

  controller_tree = lookup_widget(window, "cntrltree");
  infotxt = lookup_widget(window, "infobox");
  eventlist = lookup_widget(window, "eventlist");

  gtk_widget_show (window);

  /* load the images for the controller tree */
  load_images (window);

  /* start discovering controllers and add them to the tree */
  discover_controllers (controller_tree);

  /* add a callback to the status function if we found controllers */
  if (ctrls_found_num > 0) gtk_timeout_add ( 10000, status_check, eventlist);

  insert_event(eventlist, 0, "Array-Util started.");

  /* start the gtk main loop */
  gtk_main ();

  return (0);
}
		









