/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_MAILCLASSES
#define HAS_MAILCLASSES

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string.h>
#include <qstringlist.h>
#include <kconfig.h>

#define ISCRLF(buffer,index)    (((((buffer)[(index)  ]==0x0a) && \
                                  ((buffer)[(index+1)]==0x0d))) || \
                                 (((buffer)[(index)  ]==0x0d) && \
                                  ((buffer)[(index+1)]==0x0a)))
#define MIN_HEADER_LINE_SIZE 3

// QUOTES are needed for clearing various fields, such as addresses or names
// They are mainly used by the friend function "StripQuotes"
// See StripQuotes and miscfunctions.cpp

#define FROM_QUOTES "<[>]"
#define FROM_SEPARATORS_BEGIN "<["
#define FROM_SEPARATORS_END ">]"
#define NAME_QUOTES "\"'`*"

// SEPARATORS are needed for parsing lists of tokens
// See AddressClass, AddressListClass, addressclass.cpp and addresslistclass.cpp

#define ADDRESS_SEPARATORS ",;"
#define MIME_SEPARATORS ";"
#define MESSAGE_SEPARATOR "Message separator key.\n"


// Forward definition of certain classes. See appropriate class definitions.

class DateClass;
class AddressClass;
class DescriptorClass;
class AddressListClass;
class AttachmentListClass;
class IndexClass;
class LocalMailFolder;
//class IndexCacheClass;


// This enum defines the types of most mail-related items

enum 
{
    NotSet=0,
		UnknownItem,
    AddressListItem,
    AddressItem,
    HeaderItem,
    ToListItem,
    FromItem,
    ReplyToItem,
    SubjectItem,
    CcListItem,
    BccListItem,
    DateTimeItem,
    MsgIDItem,
    ContentTypeItem,
    BoundaryItem,
		MStatusItem,
		PriorityItem,
		ReceivedItem,
    AttachmentListItem,
		EncodingItem,
    MailItem,
		MailFolderItem
};

// Function to clear a text from unwanted characters. See the mail header for
// examples. See also miscfunctions.cpp

void fit_text(QString &srctext, QString &desttext, int size, const QFont &font);
QStringList split(const char *s, char c=0);
QString toString(QStringList &);

// Basic class for implementing most of the structure philosophy.
// getTextFromData is a generic function which will re-compose the items located
// at some level in the object hierarchy, opposite to the constructors which in
// general will parse and split objects. Each class has to define this, if
// re-composition is needed. See also BasicTreeItem and basicitem.cpp.

class BasicItem 
{
	protected:
  	void *ItemData;
	public:
	  int ItemType;  
		BasicItem *Parent;
  	BasicItem();
		int getTextFromData(char *mesg){*mesg=0;return 0;};
  	BasicItem(void *itemdata=0, void *parent=0);
  	virtual ~BasicItem();
};

// Same as BasicItem; it contains linking information for more complex data
// structures such as linked lists and trees. See also BasicItem and
// basictreeitem.cpp.

class BasicTreeItem 
{
	protected:
  	void *ItemData;
	public:
  	int ItemType;  
  	BasicTreeItem *Next;
  	BasicTreeItem *Prev;
  	BasicTreeItem *Parent;
  	BasicTreeItem *Son;
		BasicItem			*Root;
  	BasicTreeItem();
		int getTextFromData(char *mesg){*mesg=0;return 0;};
		BasicTreeItem(void *itemdata);
		BasicTreeItem(void *itemdata, BasicTreeItem *parent=0, BasicTreeItem *prev=0);
		BasicTreeItem(void *itemdata, BasicItem *root=0, BasicTreeItem *prev=0);
		BasicTreeItem(void *itemdata, BasicTreeItem *parent=0, BasicItem *root=0,
				BasicTreeItem *prev=0);
  	virtual ~BasicTreeItem();
		BasicTreeItem* getNext();
};

#endif

