
#include <kore/version.h>
#include <kore/kernel.h>
#include <kore/servicemanager.h>
 
#include "plugin.h"
 
#define MAILFILTER_PLUGIN_MAJOR 0
#define MAILFILTER_PLUGIN_MINOR 0
#define MAILFILTER_PLUGIN_REVISION 0
#define MAILFILTER_PLUGIN_VERSION "0.0.0"
#define MAILFILTER_PLUGIN_API_MAJOR 0
#define MAILFILTER_PLUGIN_API_MINOR 0
#define MAILFILTER_PLUGIN_API_REVISION 0
#define MAILFILTER_PLUGIN_API_VERSION "0.0.0"
#define MAILFILTER_PLUGIN_NAME "Mail Filter Plugin"
#define MAILFILTER_PLUGIN_TYPE "Plugin"
#define MAILFILTER_PLUGIN_DESCRIPTION "This plugin for filtering your emails."

PLUGIN_MAIN_BODY(MailFilterPlugin,libHandle,libName,libPath,libFlags); 

MailFilterPlugin::MailFilterPlugin(HMODULE libhandle, const char* libname, const char* libpath, int flags):Plugin(libhandle,libname,libpath,flags)
{
  _pluginVersion = new Version(MAILFILTER_PLUGIN_MAJOR,MAILFILTER_PLUGIN_MINOR,MAILFILTER_PLUGIN_REVISION,MAILFILTER_PLUGIN_VERSION);
  _pluginAPIVersion = new Version(MAILFILTER_PLUGIN_API_MAJOR,MAILFILTER_PLUGIN_API_MINOR,MAILFILTER_PLUGIN_API_REVISION,MAILFILTER_PLUGIN_API_VERSION);
  _pluginInfo = new Info(this, MAILFILTER_PLUGIN_NAME, MAILFILTER_PLUGIN_TYPE, MAILFILTER_PLUGIN_DESCRIPTION, _pluginVersion, _pluginAPIVersion);
}

MailFilterPlugin::~MailFilterPlugin()
{
    delete _pluginInfo;
    delete _pluginVersion;
    delete _pluginAPIVersion;
    delete filter;
}
void MailFilterPlugin::pluginLoaded()
{
    // Nothing to do here
}
void MailFilterPlugin::initPlugin()
{
    filter = new MailFilter();
    Kernel::instance()->serviceManager()->registerProvider( filter );
}
void MailFilterPlugin::unloadingPlugin()
{
    if( filter )
    {
        Kernel::instance()->serviceManager()->unregisterProvider( filter );
        delete filter;
        filter = 0;
    }
}
