/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_VTIMEZONE_COMPONENT_H
	#define HAS_VTIMEZONE_COMPONENT_H

#include <stdio.h>
#include <qstring.h>
#include <qvaluelist.h>
#include <qstringlist.h>
#include <qdatetime.h>
#include <metaobject.h>
#include <toolbox.h>
#include <rdate.h>
#include <rrule.h>

#define VTC_OK													0
#define VTC_ERROR_NULL									1
#define VTC_ERROR_DTSTART 							2
#define VTC_ERROR_NOLOCAL 							3
#define VTC_ERROR_TZOFFSETFROM					4
#define VTC_ERROR_TZOFFSETTO						5
#define VTC_WARNING_TZNAME							6
#define VTC_WARNING_MULTIPLE_RDATE 			7

struct TZData
{
	QDateTime start;
	long offsetGMT;
};


/**
 *		This class is for the components of TimeZone (Standard/DayLight)
 */
class VTimeZoneComponent
{
public:
	enum ComponentType {Standard=1, Daylight};
private:
	static int TZC_UID;
	int errorCode;
	int warningCode;
	ComponentType type;
	QDateTime dtStart; 			// the DTSTART field
	QDateTime currentStart; // computed based on DTSTART, RDATE, RRULE
	bool validDate;					// to tell us if it's a valid date
	bool lastRequired;
	long offsetTo;
	long offsetFrom;
	QString comment;
	QStringList names;
	RDate *rdate;
	RRule *rrule;
	MetaObject *mObj;
public:
	VTimeZoneComponent(MetaObject *object=NULL);
	~VTimeZoneComponent();
	QString getErrorString();
	QStringList &getNames() { return names; }
	int getErrorCode();
	/**
	 *		Function for parsing the ting and telling the beginning of the time
	 *	period for the year given as parameter.
	 */
	void setCurrentStart(int currentYear);
	/**
	 *		Function to check if the time zone component is stil valid.
	 */
	void setIsValid(bool validity);
	/**
	 *		Function to for retreiving the current beginning. returns a Period
	 *	which is:
	 *		- the QDateTime for the begining of the timezone slice (start)
	 *		- the offset to GMT (length), can be negative.
	 *		- the type (daylight=TRUE/standard=FALSE) in the isFinished field :-)
	 */
	TZData getCurrentStart();
	/**
	 *		Function to test if the component is still valid!
	 *		Calling topology:
	 *		if(isValid())
	 *		{
	 *			TZData data=getCurrentStart();
	 *			UID = generateUID();
	 *			QDict.insert(UID,data); <- the group timezone 
	 *		}
	 */
	bool isValid() { return validDate; };
	bool isLastRequired() { return lastRequired; }
	/**
	 *	Function to generate an unique ID for the object for the QDict purposes
	 */
	QString generateUID();
private:
	void parse(MetaObject *object);
};


#endif








