/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_TIMEZONE_LIST_H
	#define HAS_TIMEZONE_LIST_H

#include <vtimezone.h>
#include <qobject.h>
#include <qtimer.h>


class TimeZones: public QObject
{
	Q_OBJECT
	
public:
	enum TZPolicy { Ask=0, Keep=1, Overwrite=2, MostRecent=4 };
	enum AskValues { Undecided=0, True=1, False=2};
private:
	QStringList timezoneNames;
	QValueList<VTimeZone> timezoneList;
	QDict<int> tzNameList;
	QDict<int> tzIdList;
	TZPolicy policy;
	int year;
	int askValue;
	QTimer *timer;
	int timerValue;
	
public slots:
	void askAnswer(AskValues response);
	void internalAskAnswer();
signals:
	void askQuestion();
public:
	TimeZones(QValueList<MetaObject*> zones,
			int yr=-1,
			TimeZones::TZPolicy pol=TimeZones::MostRecent);
			
	TimeZones(MetaObject zone,
			int yr=-1,
			TimeZones::TZPolicy pol=TimeZones::MostRecent);
	
	int tzIdQuery(QString id=QString::null);
	int tzNameQuery(QString name=QString::null);
	void setYear(int yr);
	void setPolicy(TZPolicy pol);
	void setTimerValue(int milisecs);
	bool addZone(MetaObject *mObj);
	bool addZone(VTimeZone tz);
	bool removeZone(QString name, bool isTZID=false);
	bool removeZone(int index);
	
};


#endif








