/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <noteview.h>
#include <pixmaps.h>
#include <templateview.h>
#include <vfolder.h>
#include <brokeriface.h>
#include <qmessagebox.h>
#include <clientvfs.h>
#include <noteobj.h>
#include <notewidget.h>
#include <notewindow.h>
#include <noteview.h>
#include <datahandlerimpl.h>
#include <kconfig.h>

extern KConfig *GlobalConfig;

NoteView::NoteView(VFolder *folder, QWidget *parent, const char *name):SortingWidget(parent, name), TemplateView(folder)
{
	// set parameters
	setChildWidth(80);
	setChildHeight(80);
	
	// make the popups
  makeGlobalPopup();
  makeChildPopup();
	
	// scan for notes
	if(folder)
	{
		QList<VObject> noteList=folder->objectList();
		for (unsigned int i = 0; i < noteList.count(); i++)
		{
		  if( folder->isSimpleObject(noteList.at(i)->name()) )
		  {
  			// debug
  			printf("NoteView (%s): adding child %s\n", (const char *)folder->path(), (const char *)noteList.at(i)->name());

  			addChild(new NoteWidget(this, static_cast<NoteObject *>(noteList.at(i))));
  			if (static_cast<NoteObject *>((noteList.at(i)))->onDisplay())
  			{
  				NoteWindow *nwin;
  				// ROTFL!!
  				//(NoteObject *)((NoteObject *)(noteList.at(i))));
  				nwin=new NoteWindow(static_cast<NoteObject *>(noteList.at(i)));
  				nwin->show();
  				nwin->move(static_cast<NoteObject *>(noteList.at(i))->position());
  			}
		  }
		}
	}
	
	screenUpdate();
}

void NoteView::makeGlobalPopup()
{
  mainPopup=new QPopupMenu();

  mainPopup->insertItem(QIconSet(QPixmap(notes_xpm)), "New note", this, SLOT(slotNewObject()));
  mainPopup->insertSeparator();
  mainPopup->insertItem(QIconSet(QPixmap(paste_xpm)), "Paste", this, SLOT(slotPaste()));
}

void NoteView::makeChildPopup()
{
  childPopup=new QPopupMenu();

  childPopup->insertItem("Open", this, SLOT(slotOpenSelection()));
  childPopup->insertItem(QIconSet(QPixmap(notes_xpm)), "New note", this,
      SLOT(slotNewObject()));
  childPopup->insertSeparator();
  childPopup->insertItem(QIconSet(QPixmap(cut_xpm)), "Cut", this,
      SLOT(slotCutSelection()));
  childPopup->insertItem(QIconSet(QPixmap(copy_xpm)), "Copy", this,
      SLOT(slotCopySelection()));
  childPopup->insertItem(QIconSet(QPixmap(paste_xpm)), "Paste", this,
      SLOT(slotPaste()));
  childPopup->insertSeparator();
  childPopup->insertItem(QIconSet(QPixmap(delete_xpm)), "Delete", this,
      SLOT(slotDeleteSelection()));
  childPopup->insertItem("Select all", this, SLOT(slotSelectAll()));
  childPopup->insertSeparator();
  childPopup->insertItem(QIconSet(QPixmap(send_xpm)), "Send to ...");
}

void NoteView::newObject()
{
	// try to create a new object
	VFolder *folder=static_cast<VFolder *>(getVItem());
	NoteObject *item = 0;
	
	if (folder)
	{
		QString id=BrokerInterface::thisInstance()->createObject(folder->path());
		item=ClientVFS::thisInstance()->template _new<NoteObject>(folder->path()+"/"+id);
	}
	
	// check for failures
	if (!item)
	{
		QMessageBox::information(0, "Creation failed", QString("Could not create a new object in this folder.\nReason: ")+BrokerInterface::thisInstance()->lastError(), 1);
	}
	else
	{
		// save the new object, as it might have some default data
		//set up the default color, font
		GlobalConfig->setGroup("Notes");
		item->setColor(GlobalConfig->readEntry("Default color", "yellow").lower());
		item->setFont(GlobalConfig->readFontEntry("Default font"));
		item->setSize(GlobalConfig->readSizeEntry("Default size"));
		item->save();
		item->updateViews();
		// make a new NoteWindow
		NoteWindow *nwin;
		nwin=new NoteWindow(item);
		nwin->show();
	}
}

void NoteView::slotNewObject()
{
	newObject();
}

void NoteView::slotOpenSelection()
{
	openSelection();
}

void NoteView::slotDeleteSelection()
{
	deleteSelection();
}

void NoteView::slotCutSelection()
{
	cutSelection();
}

void NoteView::slotCopySelection()
{
	copySelection();
}

void NoteView::slotPaste()
{
	paste();
}

void NoteView::slotSelectAll()
{
	selectAll();
}

