/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * $Id: groupview.h,v 1.2 2001/05/19 10:53:18 alex Exp $
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_GROUPVIEW
#define HAS_GROUPVIEW

#include <qlayout.h>
#include <templateview.h>
#include <vfolder.h>
#include <datahandlerimpl.h>

class GroupTileView;
//class GroupListView;

class GroupView
	: public QWidget, public TemplateView, public DataHandlerImpl
{
	public:
		GroupView(VFolder *vfolder, QWidget *parent, const char *name=0);
		virtual ~GroupView();
		enum DisplayMode { Tile=0, List };
		void toggleDisplayMode();
		void populateViews();
		void addGroup(const QString &id);
		void removeGroup(const QString &id);
		void update();
		
		//GroupListView *getListView();
		GroupTileView *getTileView();
		
		// reimplemented from DataHandler
		void deleteSelection();
		int copySelection();
		int cutSelection();
		void paste();
		void moveSelectionTo();
		void copySelectionTo();
		void newObject();
		void openSelection();
		void selectAll();

	protected:
		DisplayMode mode;
		QHBoxLayout *main_layout;
		//GroupListView *listView;
		GroupTileView *tileView;
};

#endif








