/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <qmessagebox.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qtextstream.h>

#include <kiconloader.h>
#include <kconfig.h>

#include <cardtileview.h>
#include <templateview.h>
#include <vfolder.h>
#include <pixmaps.h>
#include <brokeriface.h>
#include <clientvfs.h>
#include <contactobj.h>
#include <cardtilewidget.h>
#include <miscfunctions.h>
#include <carddialog.h>
#include <sortingwidget.h>

#define IDSTRING "CardTileView: "

QStringList CardTileView::fields;

extern KConfig *GlobalConfig;

CardTileView::CardTileView(VFolder *folder, CardView *parent, const char *name)
  : SortingWidget(parent, name), TemplateView(folder)
{
  makeGlobalPopup();
  makeChildPopup();
	setChildWidth(250);
	setChildHeight(50);
  setXSpacing(10);
  setYSpacing(10);
	setChildFixedHeight(false);
	enableWidthResize(true);
	setCanDrawLines(true);
#ifdef DEBUG_CARDTILE
	printf(IDSTRING "Reading the configuration for displayed fields...\n");
#endif
	GlobalConfig->setGroup("Contacts");
	fields=enhancedSplit(GlobalConfig->readEntry("View fields"),';');
	// scan for Cards
	QList<VObject> contactList=folder->objectList();
	for(unsigned int i=0;i<contactList.count();i++)
	{
	  if( folder->isSimpleObject(contactList.at(i)->name()) )
	  {
  		// debug
#ifdef DEBUG_CARDTILE
  		printf(IDSTRING"(%s): adding child %s\n", (const char *)folder->path(),
  			(const char *)contactList.at(i)->name());
#endif
  		ContactObject *co;
  		co=(ContactObject *)(contactList.at(i));
  		addChild(new CardTileWidget(this, co));
	  }
	}
	sort(1);
	screenUpdate();
}

void CardTileView::makeGlobalPopup()
{
  mainPopup=new QPopupMenu();

  mainPopup->insertItem(QIconSet(BarIcon("Contacts")), "New contact", this, SLOT(slotNewObject()));
  mainPopup->insertSeparator();
  mainPopup->insertItem(QIconSet(QPixmap(paste_xpm)), "Paste", this, SLOT(slotPaste()));
  mainPopup->insertSeparator();
  mainPopup->insertItem("Select all", this, SLOT(slotSelectAll()));
#ifdef DEBUG_CARDTILE
  debug("...Create mainPopup\n");
#endif
}

void CardTileView::makeChildPopup()
{
  childPopup=new QPopupMenu();

  childPopup->insertItem(QIconSet(BarIcon("edit")), "Edit", this, SLOT(slotOpenSelection()));
  childPopup->insertItem(QIconSet(BarIcon("Contacts")), "New contact", this, SLOT(slotNewObject()));
  childPopup->insertSeparator();
  childPopup->insertItem(QIconSet(QPixmap(cut_xpm)), "Cut", this, SLOT(slotCutSelection()));
  childPopup->insertItem(QIconSet(QPixmap(copy_xpm)), "Copy", this, SLOT(slotCopySelection()));
  childPopup->insertItem(QIconSet(QPixmap(paste_xpm)), "Paste", this, SLOT(slotPaste()));
  childPopup->insertSeparator();
  childPopup->insertItem(QIconSet(QPixmap(delete_xpm)), "Delete", this, SLOT(slotDeleteSelection()));
  childPopup->insertItem("Select all", this, SLOT(slotSelectAll()));
  childPopup->insertSeparator();
  childPopup->insertItem(QIconSet(QPixmap(send_xpm)), "Mail to ...");
}


void CardTileView::newObject()
{
	// try to create a new object
	QString id=BrokerInterface::thisInstance()->createObject(getVItem()->path());
	ContactObject *item=ClientVFS::thisInstance()->template _new<ContactObject>(getVItem()->path()+"/"+id);
	
	// check for failures
	if(!item)
	{
		QMessageBox::information(0, "Creation failed",
			QString("Could not create a new object in this folder.\nReason: ")+
			BrokerInterface::thisInstance()->lastError(), 1);
	}
	else
	{
//		addChild(new CardTileWidget(this, item));
		CardDialog *vcd;
		vcd=new CardDialog(item, this);
		vcd->setTile(this);
		vcd->setFields(&fields);
		vcd->setNewCard(true);
		CardTileWidget::addContactDialog(item->path(), vcd);
		connect(vcd, SIGNAL(dialogClosed(QString)), this, SLOT(removeDialog(QString)));
		vcd->show();
	}
}

QStringList &CardTileView::getFields()
{
	return fields;
}


void CardTileView::openSelection()
{
	CardTileWidget *ctw;
	QList<DataWidget> sList;
	
	for(unsigned int i=0;i<sList.count();i++)
	{
		ctw=static_cast<CardTileWidget *>(sList.at(i));
		CardDialog *vcd;
		vcd=static_cast<CardDialog *>(ctw->dialogContactQuery(ctw->card()->path()));
		if (vcd)
		{
			vcd->raise();
		}
		else
		{
			vcd=new CardDialog(ctw->card(), this);
			ctw->addContactDialog(ctw->card()->path(), vcd);
			connect(vcd, SIGNAL(dialogClosed(QString)), this, SLOT(removeDialog(QString)));
			vcd->show();
		}
#ifdef DEBUG_CARDTILE
		printf(IDSTRING"Trying to open a child %p\n", ctw);
#endif
	}
}

void CardTileView::removeDialog(QString str)
{
	CardTileWidget::removeContactDialog(str);
}


void CardTileView::update()
{
#ifdef DEBUG_CARDTILE
	printf(" updating....\n");
#endif
}

void CardTileView::slotNewObject()
{
	newObject();
}

void CardTileView::slotOpenSelection()
{
	openSelection();
}

void CardTileView::slotDeleteSelection()
{
	deleteSelection();
}

void CardTileView::slotSelectAll()
{
	selectAll();
}

void CardTileView::slotCopySelection()
{
	copySelection();
}

void CardTileView::slotCutSelection()
{
	cutSelection();
}

void CardTileView::slotPaste()
{
	paste();
}

