/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <templateview.h>
#include <vobject.h>
#include <contactobj.h>
#include <cardlistviewitem.h>
#include <miscfunctions.h>
#include <ctype.h>

#define IDSTRING "CardListViewItem: "

// #define DEBUG_CARD_LISTITEM

CardListViewItem::CardListViewItem(ContactObject *object, CardListView *parent,  QStringList *f)
  : EListViewItem(parent), TemplateView(object)
{
	object->addView(this);
	fields=f;
	_parent=parent;
	setCard(object);
	if(fields) update();
}

CardListViewItem::~CardListViewItem()
{
}


void CardListViewItem::paintCell(QPainter * p, const QColorGroup &, int column, int w, int align)
{
	QFont f=p->font();
	int _width, _height;
	/*************** Not selected (normal) item ****************/
	_width=_parent->columnWidth(column);
	_height=height();
	p->eraseRect(0, 0, _width, _height-1); 
	QString src,dest;
	switch(column)
	{
		case 0: // painting the names (BOLD)
			f.setBold(true);
			p->setFont(f);
			src=text(0);
			p->drawText(2, 0, _width, _height, align, fitText(src, w, p->font()));
			break;
		default:
			src=text(column);
			p->drawText(2 , 0, _width, _height, align, fitText(src, w, p->font()));
			break;
	}
	// paint the line separator
	if(!column)
	{
		_width=_parent->width();
		p->setPen(QPen(QColor(0xd0, 0xd0, 0xd0), DashLine));
		p->drawLine(0, _height, _width, _height);
	}
	// paint the selected frame
	if(isSelected())
	{
		_width=_parent->width();
		_height=height()-1;
		p->setRasterOp(AndROP);  // black + normal bg
		p->fillRect(0, 0, _width, _height, QBrush(QColor(165, 188, 209)));
	}
}

/**
 *	Operators tried on paintFocus and their results:
 *		p->setRasterOp(NotAndROP); //black + greenish bg
 *		p->setRasterOp(NotOrROP);  // greenish
 */
void CardListViewItem::paintFocus (QPainter *p, const QColorGroup &, const QRect & r)
{
	int _width=_parent->width();
	int _height=height()-1;
	p->setRasterOp(AndROP);  // black + normal bg
	p->fillRect(r.left(), r.top(), _width, _height, QBrush(QColor(165, 188, 209)));
}

void CardListViewItem::setFields(int offset, ContactObject *card, QStringList *f, bool /*isRecursed*/, QWidget *parent)
{	
	QStringList tempList=split((*f)[0],'=');
#ifdef DEBUG_CARD_LISTITEM
	printf(IDSTRING"Type of column: %s\n",(const char *)tempList[0]);
#endif

	QString temp;
	bool genericAdded=false;
	for (unsigned int i=0;i<f->count();i++)
	{
		tempList=split((*f)[i],'=');
		QString content;
		if(tempList[0].lower().find("fn",0,false)!=-1)
		{
			content=getField(FN_FIELD,card,(tempList.count()==2)?tempList[1]:QString("No name"));
			contents.append(content);
			setText(i+offset,content);
		}
		else if(tempList[0].lower().find("name",0,false)!=-1)
		{
			content=getField(NAME_FIELD,card,(tempList.count()==2)?tempList[1]:QString("No name"));
			contents.append(content);
			setText(i+offset,content);
		}
		else if(tempList[0].lower()=="work address")
		{
			content=getField(WORK_ADDRESS_FIELD,card,(tempList.count()==2)?tempList[1]:QString::null);
			contents.append(content);
			setText(i+offset,content);
		}
		else if(tempList[0].lower()=="home address")
		{
			content=getField(HOME_ADDRESS_FIELD,card,(tempList.count()==2)?tempList[1]:QString::null);
			contents.append(content);
			setText(i+offset,content);
		}
		else if(tempList[0].lower()=="phone")
		{
			content=getField(PHONE_FIELD,card,(tempList.count()==2)?tempList[1]:QString::null);
			if(!content.isEmpty()) 
			{
				contents.append(content);
				setText(i+offset,content);
			}
			else if(!genericAdded)
			{
				QStringList s("generic");
				setFields(i, card, &s, true, parent);
				genericAdded=true;
			}
		}
		else if(tempList[0].lower()=="mobile")
		{
			content=getField(PHONE_FIELD,card,"mobile");
			if(!content.isEmpty())
			{
				contents.append(content);
				setText(i+offset,content);
			}
			else if(!genericAdded)
			{
				QStringList s("generic");
				setFields(i, card, &s, true, parent);
				genericAdded=true;
			}
		}
		else if(tempList[0].lower()=="generic")
		{
			content=getField(PHONE_FIELD,card,"generic");
			contents.append(content);
			setText(i+offset,content);
		}
		else if(tempList[0].lower()=="fax")
		{
			content=getField(PHONE_FIELD,card,"fax");
			if(!content.isEmpty())
			{
				contents.append(content);
				setText(i+offset,content);
			}
			else if(!genericAdded)
			{
				QStringList s("generic");
				setFields(i, card, &s, true, parent);
				genericAdded=true;
			}
		}
		else if(tempList[0].lower()=="voice")
		{
			content=getField(PHONE_FIELD,card,"voice");
			if(!content.isEmpty())
			{
				contents.append(content);
				setText(i+offset,content);
			}
			else if(!genericAdded)
			{
				QStringList s("generic");
				setFields(i, card, &s, true, parent);
				genericAdded=true;
			}
		}
		else if(tempList[0].lower()=="email")
		{
			content=getField(DEFAULT_EMAIL_FIELD,card);
			contents.append(content);
			setText(i+offset,content);
		}
		else if(tempList[0].lower()=="url")
		{
			content=getField(URL_FIELD,card);
			contents.append(content);
			setText(i+offset,content);
		}
		else if(tempList[0].lower()=="title")
		{
			content=getField(TITLE_FIELD,card);
			contents.append(content);
			setText(i+offset,content);
		}
		else if(tempList[0].lower()=="role")
		{
			content=getField(ROLE_FIELD,card);
			contents.append(content);
			setText(i+offset,content);
		}
		else if(tempList[0].lower()=="org")
		{
			content=getField(ORGANIZATION_FIELD,card);
			contents.append(content);
			setText(i+offset,content);
		}
		else if(tempList[0].lower()=="class")
		{
			content=getField(CLASS_FIELD,card);
			contents.append(content);
			setText(i+offset,content);
		}
	}
#ifdef DEBUG_CARD_LISTITEM
	if(!isRecursed)
	{
		printf(IDSTRING"Number of columns... %d\n", contents.count());
		for (unsigned int i=0; i<contents.count(); i++)
		{
			printf(IDSTRING"Contents[%d]: %s\n",i, (const char *)contents[i]);
		}
	}
#endif
}

QString CardListViewItem::getField(int which, ContactObject *card, QString codes)
{
#ifdef DEBUG_CARD_LISTITEM
	printf(IDSTRING"getField %d...\n",which);
#endif
	switch(which)
	{
		case NAME_FIELD	:
			if(card->n().count())
				return processName(card->n(), codes);
		case HOME_ADDRESS_FIELD:
			{
				bool flag=false;
				for (unsigned int i=0; i<card->homeAdr().count(); i++) {
					if (!card->homeAdr()[i].isEmpty()) {
						flag=true; break;
					}
				}
				if(flag)
					return processAddress(card->homeAdr(), codes);
			}
			break;
		case PHONE_FIELD:
			if(card->phone().count())
				return processPhone(card, codes);
			break;
		case WORK_ADDRESS_FIELD:
			{
				bool flag=false;
				for (unsigned int i=0; i<card->workAdr().count(); i++) {
					if (!card->workAdr()[i].isEmpty()) {
						flag=true; break;
					}
				}
				if (flag)
					return processAddress(card->workAdr(), codes);
			}
			break;
		case DEFAULT_EMAIL_FIELD:
			if(card->emails().count())
				return card->emails()[card->defaultEmail()];
			break;
		case URL_FIELD:
			if(card->URLs().count())
				return card->URLs()[0];
			break;
		case TITLE_FIELD:
			if(!card->title().isEmpty())
				return card->title();
			break;
		case ROLE_FIELD:
			if(!card->role().isEmpty())
				return card->role();
			break;
		case ORGANIZATION_FIELD:
			if(!card->org().isEmpty())
				return card->org();
			break;
		case CLASS_FIELD:
			if(!card->classCard().isEmpty())
				return card->classCard();
			break;
		case FN_FIELD:
			if(!card->fn().isEmpty())
				return card->fn();
			break;
	}
	return QString::null;
}

QString CardListViewItem::processName(QStringList n, QString codes)
{
#ifdef DEBUG_CARD_LISTITEM
	printf(IDSTRING"Processing name...\n");
#endif
	QString result=QString::fromLatin1(" ")+codes+QString::fromLatin1("  ");
	if(codes.isEmpty())
		result=" name surname, other  ";
	int pos, t;
	pos=result.find("surname",0,false);
	if(pos!=-1) result.replace(pos,7,(n[1].length()) ? n[1] : QString(" "));
	pos=result.find("name",0,false);
	if(pos!=-1) result.replace(pos,4,(n[0].length()) ? n[0] : QString(" "));
	pos=result.find("suffix",0,false);
	if(pos!=-1) result.replace(pos,6,(n[4].length()) ? n[4] : QString(" "));
	pos=result.find("prefix",0,false);
	if(pos!=-1) result.replace(pos,6,(n[3].length()) ? n[3] : QString(" "));
	pos=result.find("other",0,false);
	if(pos!=-1) result.replace(pos,5,(n[2].length()) ? n[2] : QString(" "));
	bool flag=true;
	// i have @ least 3 spaces!
	pos=0;
	while(flag)
	{
		QString tmp;
		t=pos;
		if(result.find(' ',pos+2)==t+2)
		{
			tmp.sprintf("%c",((const char *)result)[pos+2]);
			result.replace(pos,3,tmp);
		}
		if(result.find("\\n",pos+2)==t+2)
		{
			result.replace(pos,2,"");
		}
		pos=result.find(' ',pos+1);
		if(pos==-1) flag=false;
	}
	flag=true;
	// replacing \\n with \n
	pos=0;
	result=result.simplifyWhiteSpace().stripWhiteSpace();
#ifdef DEBUG_CARD_LISTITEM
	printf("Final name: %s\n", (const char *)result);
#endif
	while(!isalnum(((const char *)result)[result.length()-1]) && result.length()!=0)
		result.remove(result.length()-1,1);
	return result;
}
QString CardListViewItem::processAddress(QStringList adr, QString codes)
{
	QString result;
	if(!codes)
		result=" po-box, street\\ncity, region\\ncountry  ";
	else
		result=QString(" ")+codes+QString(" ");
	int pos, t;
	pos=result.find("po-box",0,false);
	if(pos!=-1) result.replace(pos,6,(adr[0].length()) ? adr[0] : QString(" "));
	pos=result.find("extended",0,false);
	if(pos!=-1) result.replace(pos,8,(adr[1].length()) ? adr[1] : QString(" "));
	pos=result.find("street",0,false);
	if(pos!=-1) result.replace(pos,6,(adr[2].length()) ? adr[2] : QString(" "));
	pos=result.find("city",0,false);
	if(pos!=-1) result.replace(pos,4,(adr[3].length()) ? adr[3] : QString(" "));
	pos=result.find("region",0,false);
	if(pos!=-1) result.replace(pos,6,(adr[4].length()) ? adr[4] : QString(" "));
	pos=result.find("code",0,false);
	if(pos!=-1) result.replace(pos,4,(adr[5].length()) ? adr[5] : QString(" "));
	pos=result.find("country",0,false);
	if(pos!=-1) result.replace(pos,7,(adr[6].length()) ? adr[6] : QString(" "));
	bool flag=true;
	// i have @ least 3 spaces!
	pos=0;
	while(flag)
	{
		QString tmp;
		t=pos;
		if(result.find(' ',pos+2)==t+2)
		{
			tmp.sprintf("%c",((const char *)result)[pos+2]);
			result.replace(pos,3,tmp);
		}
		if(result.find("\\n",pos+2)==t+2)
		{
			result.replace(pos,2,"");
		}
		pos=result.find(' ',pos+1);
		if(pos==-1) flag=false;
	}
	flag=true;
	// replacing \\n with \n
	pos=0;
	while(flag)
	{
		pos=result.find("\\n",pos);
		if(pos!=-1)
			result.replace(pos,2,"\n");
		else
			flag=false;
	}
	result=result.stripWhiteSpace();
	while(!isalnum(((const char *)result)[result.length()-1]) && result.length()!=0)
		result.remove(result.length()-1,1);
	return result.simplifyWhiteSpace();
}
QString CardListViewItem::processPhone(ContactObject *card, QString codes)
{
	QString result=QString::null;
	QStringList cList=split(codes,',');
	QStringList p=card->phone();
	QStringList pt=card->phoneType();
	for (unsigned int i=0;i<cList.count();i++)
	{
		if(cList[i]=="work+voice")
		{
			for (unsigned int j=0; j<pt.count(); j++)
				if(pt[i].find("work",0,false)!=-1 && pt[i].find("voice",0,false)!=-1)
					result.append(p[i].stripWhiteSpace()+" (work, voice)\n");
		}
		else if(cList[i]=="work+fax")
		{
			for (unsigned int j=0;j<pt.count();j++)
				if(pt[i].find("work",0,false)!=-1 && pt[i].find("fax",0,false)!=-1)
					result.append(p[i].stripWhiteSpace()+" (work,fax)\n");
		}
		else if(cList[i]=="work+mobile")
		{
			for (unsigned int j=0;j<pt.count();j++)
				if(pt[i].find("work",0,false)!=-1 && pt[i].find("mobile",0,false)!=-1)
					result.append(p[i].stripWhiteSpace()+" (work,mobile)\n");
		}
		else if(cList[i]=="work+other")
		{
			for (unsigned int j=0;j<pt.count();j++)
				if(pt[i].find("work",0,false)!=-1 && pt[i].find("voice",0,false)==-1 && pt[i].find("fax",0,false)==-1 &&
						pt[i].find("mobile",0,false)==-1)
					result.append(p[i].stripWhiteSpace()+" (work,mobile)\n");
		}
		if(cList[i]=="home+voice")
		{
			for (unsigned int j=0;j<pt.count();j++)
				if(pt[i].find("home",0,false)!=-1 && pt[i].find("voice",0,false)!=-1)
					result.append(p[i].stripWhiteSpace()+" (home, voice)\n");
		}
		else if(cList[i]=="home+fax")
		{
			for (unsigned int j=0;j<pt.count();j++)
				if(pt[i].find("home",0,false)!=-1 && pt[i].find("fax",0,false)!=-1)
					result.append(p[i].stripWhiteSpace()+" (home,fax)\n");
		}
		else if(cList[i]=="home+mobile")
		{
			for (unsigned int j=0;j<pt.count();j++)
				if(pt[i].find("home",0,false)!=-1 && pt[i].find("mobile",0,false)!=-1)
					result.append(p[i].stripWhiteSpace()+" (home,mobile)\n");
		}
		else if(cList[i]=="home+other")
		{
			for (unsigned int j=0;j<pt.count();j++)
				if(pt[i].find("home",0,false)!=-1 && pt[i].find("voice",0,false)==-1 && pt[i].find("fax",0,false)==-1 &&
						pt[i].find("mobile",0,false)==-1)
					result.append(p[i].stripWhiteSpace()+" (home,mobile)\n");
		}
		else if(cList[i]=="mobile")
		{
			for (unsigned int j=0;j<pt.count();j++)
				if(pt[i].find("mobile",0,false)!=-1)
					result.append(p[i].stripWhiteSpace()+"\n");
		}
		else if(cList[i]=="fax")
		{
			for (unsigned int j=0; j<pt.count(); j++)
				if(pt[i].find("fax",0,false) != -1)
					result.append(p[i].stripWhiteSpace()+"\n");
		}
		else if(cList[i]=="voice")
		{
			for (unsigned int j=0; j<pt.count(); j++)
				if(pt[i].find("voice",0,false) != -1)
					result.append(p[i].stripWhiteSpace()+"\n");
		}
		else if(cList[i]=="generic")
		{
			result.append(p[0].stripWhiteSpace()+"\n");
		}
	}
	// removing the last \n thing
	if(!result.isEmpty())
		result.remove(result.length()-1,1);
	return result.simplifyWhiteSpace();
}

void CardListViewItem::update()
{
#ifdef DEBUG_CARD_LISTITEM
	printf(IDSTRING"Updating the fields...\n");
#endif
	setFields(0, card(), fields);
}
void CardListViewItem::setCard(ContactObject *newCard)
{
	_card=newCard;
}
ContactObject *CardListViewItem::card()
{
	return _card;
}

void CardListViewItem::mouseDoubleClickEvent(QMouseEvent *)
{
	openYourself();
}


void CardListViewItem::openYourself()
{
	printf(IDSTRING"------------>> OPEN YOURSELF <<--------------\n");
}
