/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <kiconloader.h>

#include <browsewidget.h>
#include <ebutton.h>
#include <ecollection.h>
#include <foldertree.h>
#include <foldertreeitem.h>
#include <clientvfs.h>
#include <qwindowsstyle.h>
#include <qmotifstyle.h>
#include <qplatinumstyle.h>
#include <contentswidget.h>
#include <etab.h>
#include <epanel.h>
#include <kconfig.h>
#include <esplash.h>
#include <mainwindow.h>
#include <pixlibrary.h>
#include <qwidgetstack.h>
#include <qlabel.h>

#include <pluginmanager.h>
#include <uiservice.h>
#include <jabberservice.h>
#include <korganizerservice.h>

#define TAB_WIDTH 150
#define TREE_WIDTH 200

extern KConfig *GlobalConfig;
extern ESplash *s;

#define JABBER_WINDOW_ID    1

BrowseWidget *BrowseWidget::inst;

BrowseWidget *BrowseWidget::ref()
{
	return inst;
}

BrowseWidget::BrowseWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
	inst=this;

	// Create widget stack
	m_widgetStack = new QWidgetStack(this);

	// Create 'home' graphic label
	m_homeGraphic = new QLabel(m_widgetStack);
	m_homeGraphic->setPixmap(BarIcon("aethera-home"));

	// Create tree
	tree = getNewTree(m_widgetStack, true);

	// Add graphic and tree to widget stack
	m_widgetStack->addWidget(m_homeGraphic, 0);
	// Add the plug ins
	UIService *jabber = dynamic_cast<UIService*> ( PlugInManager::thisInstance()->serviceManager->registeredProvider(JABBERSERVICE_SERVICE) );
	if( jabber )
	  m_widgetStack->addWidget(jabber->mainWindow(m_widgetStack), JABBER_WINDOW_ID);
  // Add the tree
	m_widgetStack->addWidget(tree, 2);
	
	// Start displaying 'home' graphic
	m_widgetStack->raiseWidget(m_homeGraphic);

	QVBoxLayout *layout = new QVBoxLayout(this);
	layout->addWidget(m_widgetStack);
	
	connect(tree, SIGNAL(currentChanged(FolderTreeItem *)),
		this, SLOT(folderClicked(FolderTreeItem *)));

}

BrowseWidget::~BrowseWidget()
{
}

void BrowseWidget::usePathAsRoot(const QString &path)
{
	if(path == "/Magellan") {
		m_widgetStack->raiseWidget(m_homeGraphic);
		ContentsWidget::ref()->showFolder(path);
	}
	//XXX:DIMI
	if(path == "/Magellan/Jabber"){
		m_widgetStack->raiseWidget(JABBER_WINDOW_ID);
		ContentsWidget::ref()->showFolder(path);
	}
	// / XXX:DIMI
	if(path == "/Magellan/KOrganizer"){
		m_widgetStack->raiseWidget(m_homeGraphic);
		ContentsWidget::ref()->showFolder(path);
	}

	VFolder *vfolder = ClientVFS::thisInstance()->folderRef(path);

	if(vfolder) {
		m_widgetStack->raiseWidget(tree);

		tree->clear();
		FolderTreeItem *folder = new FolderTreeItem(tree, vfolder);
	
  		folder->setText(0, vfolder->name());
  		folder->setPixmap(0, BarIcon(pixmapName(vfolder->viewType())));
  		folder->setOpen(true);

		vfolder->setIconView(folder);

		// Add child folders to listview
  		QStringList folders=ClientVFS::thisInstance()->folderList(path);

  		for(unsigned int i=0;i<folders.count();i++)
    			makeBranch(folders[i], folder, true);

		// update content pane
		folderClicked(folder);
	}
}

FolderTree *BrowseWidget::getNewTree(QWidget *parent, bool main)
{
	FolderTree *_tree=new FolderTree(parent);
  _tree->setStyle(new QWindowsStyle);
  _tree->setRootIsDecorated(true);
  _tree->addColumn("Name");
	_tree->setColumnWidthMode(0, QListView::Maximum);

  FolderTreeItem *root=new FolderTreeItem(_tree, 0);
  root->setText(0, "Aethera");
  root->setPixmap(0, PixLibrary::thisInstance()->pixmap(PixLibrary::MagellanIcon));
	root->setOpen(true);

  // browse for child folders
  QStringList folders=ClientVFS::thisInstance()->folderList(ClientVFS::thisInstance()->root());

  for (unsigned int i=0; i < folders.count(); i++)
  {
    makeBranch(folders[i], root, main);
  }
	
	if(main) _tree->initFolderManagement();
	
	return _tree;
}

void BrowseWidget::makeBranch(QString path, FolderTreeItem *parent, bool main)
{
  VFolder *vfolder=ClientVFS::thisInstance()->folderRef(path);
  FolderTreeItem *folder=new FolderTreeItem(parent, vfolder);
  folder->setText(0, vfolder->name());
  folder->setPixmap(0, BarIcon(pixmapName(vfolder->viewType())));
	
	if(main) vfolder->setIconView(folder);

  // browse for child folders
  QStringList folders=ClientVFS::thisInstance()->folderList(path);

  for(unsigned int i=0;i<folders.count();i++)
  {
    makeBranch(folders[i], folder, main);
  }
}

void BrowseWidget::createFolderView(VFolder *folder)
{
	VFolder *parentFolder=ClientVFS::thisInstance()->parentFolder(folder);
	FolderTreeItem *parentView;
	
	if(parentFolder) parentView=(FolderTreeItem *)parentFolder->getIconView();
	else parentView=(FolderTreeItem *)tree->firstChild();
		
	makeBranch(folder->path(), parentView, true);
	
	parentView->setOpen(true);
	parentView->repaint();
	
	// todo: create secondary icon views
}

QString BrowseWidget::pixmapName(QString type)
{
  // folder type - pixmap mapping
  if(type=="genmail")
    return "MailContainer";
  if(type=="contacts")
    return "Contacts";
  if(type=="inbox")
    return "Inbox";
  if(type=="outbox")
    return "Outbox";
  if(type=="sent")
    return "SentMail";
  if(type=="drafts")
    return "Drafts";
  if(type=="saved")
    return "SavedMessages";
  if(type=="notes")
    return "Notes";
  if(type=="mail" || type=="imap")
    return "MailFolder";
  if(type=="deleted")
    return "Trash";
  if(type=="groups")
    return "Groups";
}

void BrowseWidget::folderClicked(FolderTreeItem *folderItem)
{	
	if(folderItem)
	{
		if(folderItem->getVItem())
		{
			ContentsWidget::ref()->showFolder(folderItem->getVItem()->path());
		}
		else
		{
			ContentsWidget::ref()->showFolder("/Magellan");
		}
	}
}

void BrowseWidget::updateFolderTreeItem(FolderTreeItem *folderItem)
{
  FolderTreeItem *item;
  if( !folderItem )
    item=(FolderTreeItem*)tree->currentItem();
  else
    item=folderItem;

  item->update();
}




