/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <identityframe.h>
#include <videotoolbox.h>
#include <definedmessages.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <names.h>

extern VideoToolBox vtb;

IdentityFrame::IdentityFrame(QWidget *parent, QString name,
	int x, int y, int dx, int dy, int idx) :
	QFrame(parent, name)
{
	index=idx;
	setGeometry(x, y, dx, dy);
	setFrameStyle(0);
	// Creating the continue-cancel buttons
	// The buttons are going to be in the bottom right
	int x,y;
	x=dx-280, y=dy-vtb.fontHeight();
	backButton=vtb.setUpQPushButton(this,"Back",
		80, vtb.fontHeight(), &x, &y);
	x=dx-180, y=dy-vtb.fontHeight();
	continueButton=vtb.setUpQPushButton(this,"Next",
		80, vtb.fontHeight(), &x, &y);
	continueButton->setDefault(true);
	x=dx-80, y=dy-vtb.fontHeight();
	finishButton=vtb.setUpQPushButton(this,"Cancel",
		80, vtb.fontHeight(), &x, &y);
	// create the text
	int DX=5, DY=5;
	vtb.setUpFonts(QFont("helvetica",12,QFont::Normal));
	text=vtb.setUpLabelSize(this,"The details you enter are "
		"used to better customize your profile.",
		dx-vtb.fontHeight()-10, &DX, &DY);
	DY+=vtb.fontHeight()+vtb.offsetY();
	DX=5;
	int align=vtb.stringLength("Organization:");
	nameLabel=vtb.setUpLabelSize(this,"Your name:",align, &DX, &DY);
	nameEdit=vtb.setUpLineEdit(this, dx-DX-5,vtb.fontHeight(), &DX, &DY);
	DX=5; DY+=vtb.fontHeight()+vtb.offsetY();
	emailLabel=vtb.setUpLabelSize(this,"E-mail:",align, &DX, &DY);
	emailEdit=vtb.setUpLineEdit(this, dx-DX-5,vtb.fontHeight(), &DX, &DY);
	DX=5; DY+=vtb.fontHeight()+vtb.offsetY();
	replyToLabel=vtb.setUpLabelSize(this,"Reply to:",align, &DX, &DY);
	replyToEdit=vtb.setUpLineEdit(this, dx-DX-5,vtb.fontHeight(), &DX, &DY);
	DX=5; DY+=vtb.fontHeight()+vtb.offsetY();
	organizationLabel=vtb.setUpLabelSize(this,"Organization:",align, &DX, &DY);
	organizationEdit=vtb.setUpLineEdit(this, dx-DX-5,vtb.fontHeight(),
		&DX, &DY);
		
	// filling up the fields...
	nameEdit->setText(Names::systemUserName());
	emailEdit->setText(Names::systemFromAddress());
	replyToEdit->setText(Names::systemReplyAddress());

	DX=5; DY+=vtb.fontHeight()+vtb.offsetY();
	attachBiz=vtb.setUpQCheckBox(this,
		"Attach my business card to outgoing E-mails", &DX, &DY);
	DX=5; DY+=vtb.fontHeight()+vtb.offsetY();
	detailsLabel=vtb.setUpLabel(this,"You can fill up your business card"
		" details later on.",&DX, &DY);
	
	connect(backButton, SIGNAL(clicked()), this, SLOT(backClicked()));
	connect(continueButton, SIGNAL(clicked()), this, SLOT(continueClicked()));
	connect(finishButton, SIGNAL(clicked()), this, SLOT(finishClicked()));
}
void IdentityFrame::continueClicked()
{
	QStringList rez;
	rez.append("[Identity]");
	rez.append(QString("Name=")+nameEdit->text());
	rez.append(QString("Email=")+emailEdit->text());
	rez.append(QString("ReplyTo=")+replyToEdit->text());
	rez.append(QString("Organization=")+organizationEdit->text());
	rez.append(QString("Attach=")+QString((attachBiz->isChecked())?"Yes":"No"));
	emit result(ContinueMessage, index, rez);
	close();
}

void IdentityFrame::finishClicked()
{
	emit result(CancelMessage, index, QStringList(""));
	close();
}

void IdentityFrame::backClicked()
{
	emit result(BackMessage, index, QStringList(""));
	close();
}
