/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __MagellanObjectRequestBroker__
#define __MagellanObjectRequestBroker__

#include <qstring.h>
#include <qstringlist.h>
#include <qcstring.h>
#include <urlmanager.h>
#include <collectionmanager.h>
#include <servernotifier.h>

class ObjectRequestBroker : public URLManager, public CollectionManager
{
  public:
    ObjectRequestBroker();
    ~ObjectRequestBroker();
    static ObjectRequestBroker *thisInstance();

    // object handling methods
    /** Get the object data.*/
    bool getObjectData(const QString &url, QByteArray &data);		
    /** Get the objects data.*/
    bool getObjectData(const QStringList &urls, QByteArray &data);		
    /** Get the data for all children from the folder.*/
    bool getChildrenData(const QString &url, QByteArray &data);		
    /** Set the object data.*/
    bool setObjectData(const QString &url, const QByteArray &data);
    /** Set the objects data.*/
    bool setObjectsData(const QStringList &url, const QByteArray &data);
    /** Set the data for all children from the folder.*/
    bool setChildrenData(const QString &url, const QByteArray &data);
    QString createObject(QString folder_url);
    QString copy(QString url, QString dest_folder_url);
    QString move(QString url, QString dest_folder_url);
    bool send(QString url);
    /** Remove an object.*/
    bool remove(QString url);
    /** Remove a folder.*/
    bool removeFolder(QStringList paramList);
		
		// notifiers
		bool registerNotify(QString url);

    // error handling methods
    QString lastError();
    void clearStatus();
	protected:
		bool getMailData(const QString &url, QByteArray &data);
		bool getMailPropertyData(const QString &url, const QString &property, QByteArray &data);
		bool getPartData(const QString &url, QByteArray &data);
		bool getFolderCacheData(const QString &url, QByteArray &data);
		bool getFolderAttributeData(const QString &url, QByteArray &data);
		bool getMailAttributeData(const QString &url, QByteArray &data);
		bool getPartAttributeData(const QString &url, QByteArray &data);
		bool getBlockObjectAttributeData(const QString &url, QByteArray &data);
		bool getBlockObjectData(const QString &url, QByteArray &data);
		bool getAttributeData(const QString &url, QByteArray &data);
		bool getCollectionObjectData(const QString &url, QByteArray &data);
		bool getFileObjectData(const QString &url, QByteArray &data);
		
		bool setCollectionObjectData(const QString &url, const QByteArray &data);
		bool setPartData(const QString &url, int part, const QByteArray &data);
		bool setMailData(const QString &url, const QByteArray &data);
		bool setMailPropertyData(const QString &url, const QString &property, const QByteArray &data);
		bool setPartAttributeData(const QString &url, const QByteArray &data);
  private:
    // instance pointer
    static ObjectRequestBroker *inst;

    QString err;
};

#endif

