/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <accounts.h>
#include <kconfig.h>
#include <names.h>
#include <qstring.h>
#include <stdio.h>

extern KConfig *GlobalConfig;

Account::Account(QString acc_name)
{
  if(acc_name.isEmpty())
  {
    printf("ERROR: cannot setup an account with an empty name.\n");
    return;
  }
  printf("Trying to set up account %s...\n", (const char *)acc_name);
	
	accname=acc_name;
  
  QString cname="Account ";
  cname+=acc_name;
  GlobalConfig->setGroup(cname);

	// account type
	QString t=GlobalConfig->readEntry("Type");
	if(t=="POP3")
		type=POP3;
	else if(t=="IMAP4")
		type=IMAP4;
	else
		type=MAILBOX;
	
	// SMTP server& and port
	s_port=GlobalConfig->readNumEntry("SPort");
	smtp=GlobalConfig->readEntry("Smtp");
	
	// SMTP defaults
	if(s_port==0)
		s_port=25;
	if(smtp.isEmpty())
		smtp=Names::systemSMTPServerName();
	
	// "From" address
	from=GlobalConfig->readEntry("From");
	
	// "From" default
	if(from.isEmpty())
		from=Names::systemFromAddress();
	
	// "Reply-To" address
	reply=GlobalConfig->readEntry("Reply To");
	
	// full user name
	name=GlobalConfig->readEntry("Name");
	
	// name default
	if(name.isEmpty())
		name=Names::systemUserName();
	
	// speed
	speed=GlobalConfig->readEntry("Speed").lower();
	
	// speed default
	if(speed.isEmpty() || !QString("normal, slow, very slow").contains(speed))
		speed="normal";
	
	// max download
  max_dl=GlobalConfig->readNumEntry("Max download");

	// enabled
  enabled=GlobalConfig->readEntry("Enabled")=="No"?false:true;
	
	// max download action
  QString act=GlobalConfig->readEntry("Max action");
  max_action=act=="ignore"?ignore:(act=="remove"?remove:ask);
	
	if(type==MAILBOX)
	{
		// mailbox
		mbox=GlobalConfig->readEntry("Mailbox");
		
		// mailbox default
		if(mbox.isEmpty())
			mbox=Names::systemMailbox();
	}
	else
	{
		// server
		server=GlobalConfig->readEntry("Server");
		
		// port
		port=GlobalConfig->readNumEntry("Port");
		
		// server defaults
		if(server.isEmpty())
			if(type==POP3)
				server=Names::systemPOP3ServerName();
			else
				server=Names::systemIMAP4ServerName();
			
		// port defaults
		if(!port)
			if(type==POP3)
				port=110;
			else
				port=143;
			
		// server login
		user=GlobalConfig->readEntry("User");
		
		// login default
		if(user.isEmpty())
			user=Names::systemServerLoginName();
		
		// has password?
		haspassword=GlobalConfig->readEntry("Remember password")=="Yes"?true:false;
		
		// password
		if(haspassword)
			password=GlobalConfig->readEntry("Password");
		
  	if(type==POP3) // POP3 specific options
		{
			// persistence
			persistence=GlobalConfig->readUnsignedNumEntry("Persistence");

			// leave on server
			leave=GlobalConfig->readEntry("Leave on server")=="Yes"?true:false;
			
			// sync on delete
  		sync=GlobalConfig->readEntry("Sync")=="Yes"?true:false;
			
			// retrieve sorted by size
  		sorted=GlobalConfig->readEntry("Sorted")=="Yes"?true:false;
		}
		else // IMAP specific options
		{
			// mailbox
			mbox=GlobalConfig->readEntry("Mailbox");
			
			// mailbox default
			if(mbox.isEmpty())
				mbox="Inbox";
		}
	}
	
	getdisabled=false;
}




