/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <netgroup.h>
#include <netprotocol.h>
#include <netsmtp.h>
#include <stdio.h>

NetSMTP::NetSMTP():NetProtocol()
{
}

NetSMTP::NetSMTP(const char *category):NetProtocol(category)
{
}

bool NetSMTP::send(const string &from_addr, const string &to_addr, const string &mesg, const string &host, int port)
{
	string rep;
		
	connect(host, port);
	if(!isConnected())
	{
		smtp_error=netsock.error();
		return false;
	}

	// connection server message
	(*this)>>rep;
	if(rep.substr(0, 2)!="22")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	
	// helo
	(*this)<<"helo "<<host.substr(0, host.find("."))<<"\r\n";
	(*this)>>rep;
	if(rep.substr(0, 2)!="25")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	
	// mail from
	(*this)<<"mail from: "<<from_addr<<"\r\n";
	(*this)>>rep;
	if(rep.substr(0, 2)!="25")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	
	// rcpt to
	(*this)<<"rcpt to: "<<to_addr<<"\r\n";
	(*this)>>rep;
	if(rep.substr(0, 2)!="25")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	
	// data
	(*this)<<"data\r\n";
	(*this)>>rep;
	if(rep.substr(0, 3)!="354")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	(*this)<<mesg<<"\r\n.\r\n";
	(*this)>>rep;
	if(rep.substr(0, 2)!="25")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	
	// quit
	(*this)<<"quit\r\n";
	
	return true;
}

bool NetSMTP::send(const string &from_addr, const vector<string> &to_addr_list, const string &mesg, const string &host, int port)
{
	string rep;
	
	connect(host, port);
	if(!isConnected())
	{
		smtp_error=netsock.error();
		return false;
	}

	// set line mode
	setMode(SMTP_Read_Line);

	// connection server message
	(*this)>>rep;
	
	// debug
	printf("netsmtp: [send] rep [%s]\n", rep.c_str());
	
	if(rep.substr(0, 2)!="22")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	
	// helo
	(*this)<<"helo "<<host.substr(0, host.find('.'))<<"\r\n";
	(*this)>>rep;
	
	// debug
	printf("netsmtp: [send] rep [%s]\n", rep.c_str());
	
	if(rep.substr(0, 2)!="25")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	
	// mail from
	(*this)<<"mail from: "<<from_addr<<"\r\n";
	(*this)>>rep;
	
	// debug
	printf("netsmtp: [send] rep [%s]\n", rep.c_str());
	
	if(rep.substr(0, 2)!="25")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	
	// rcpt to
	for(unsigned int i=0;i<to_addr_list.size();i++)
	{
		(*this)<<"rcpt to: "<<to_addr_list[i]<<"\r\n";
		(*this)>>rep;
	
		// debug
		printf("netsmtp: [send] rep [%s]\n", rep.c_str());
	
		if(rep.substr(0, 2)!="25")
		{
			smtp_error=rep.empty()?string("no response from server"):rep;
			disconnect();
			return false;
		}
	}
	
	// data
	(*this)<<"data\r\n";
	(*this)>>rep;
	
	// debug
	printf("netsmtp: [send] rep [%s]\n", rep.c_str());
	
	if(rep.substr(0, 3)!="354")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
//	(*this)<<mesg<<"\r\n.\r\n";
	sendData(mesg);
	(*this)<<"\r\n.\r\n";
	(*this)>>rep;
	
	// debug
	printf("netsmtp: [send] rep [%s]\n", rep.c_str());
	
	if(rep.substr(0, 2)!="25")
	{
		smtp_error=rep.empty()?string("no response from server"):rep;
		disconnect();
		return false;
	}
	
	// quit
	(*this)<<"quit\r\n";
	
	return true;
}

void NetSMTP::sendData(const string &data)
{
  int size=1024;
	int length=data.length();
	
	for(int offset=0;offset<length;offset+=size)
	{
		(*this)<<data.substr(offset, size);
	}
}

string NetSMTP::error()
{
	return smtp_error;
}

NetSocket& NetSMTP::socket()
{
	return NetProtocol::socket();
}

