/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __EyeTab__
#define __EyeTab__

#include <qstring.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qlist.h>
#include <qlayout.h>
#include <qevent.h>

#define TAB_HEIGHT 25
#define TAB_SPACING 6
#define TAB_LEFT_SPACING 10
#define TAB_SLOPE_WIDTH 5
#define TAB_CONTENT_OFFSET 5

class ETab;

class ETabWidget : public QWidget
{
	friend class ETab;
	private:
		ETabWidget(QWidget *parent, const char *name=0);
		void setLabel(const QString &text);
		void setPixmap(const QPixmap &pix);
		void paintEvent(QPaintEvent *p);
		
		QPixmap pixmap;
		QString label;
};

class ETabData
{
	friend class ETab;
	private:
		int index;
		QWidget *widget;
		ETabWidget *tab;
		QString label;
		QPixmap activePixmap, inactivePixmap;
};

class ETab : public QWidget
{
	Q_OBJECT
	public:
		ETab(QWidget *parent=0, const char *name=0);
		~ETab();
		
		// add a tab, given a widget and (optionally) a label and pixmap; returns the tab index; takes ownership of the widget
		int addTab(QWidget *, const QString &label, const QPixmap &inactivePixmap, const QPixmap &activePixmap);
		int addTab(QWidget *, const QString &label=QString::null);
		int addTab(QWidget *, const QPixmap &inactivePixmap, const QPixmap &activePixmap);

		// removes a tab (deletes the widget as well); warning: deleting a tab does not change the indexes
		bool removeTab(int);
		bool removeTab(QWidget *);

		// returns the number of tabs		
		int tabCount();
		
		// returns the tab index for a given widget
		int tabIndex(QWidget *);
		
		// returns the current tab index
		int currentTab();
		
		// returns the current tab widget
		QWidget *currentTabWidget();
	public slots:
		// activate a tab, based on its index
		void activateTab(int);
	
		// activate a tab, based on the widget pointer
		void activateTab(QWidget *);
	signals:
		// this signal gets emitted after a new tab has been selected
		void tabActivated(int newTab);
	
		// this signal gets emitter before a new tab is selected; use it to update your widgets on-request only
		void tabSelected(int oldTab, int newTab);
	private:
		bool eventFilter(QObject *, QEvent *);	
		void rearrange();
			
		int lastTabIndex;
		int currentTabIndex;
		QList<ETabData> tabList;
		QVBoxLayout *layout;
};

#endif
