/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <personalwidgetbase.h>
#include <cardclasses.h>
#include <personalwidget.h>
#include <phonewidget.h>
#include <mailwidget.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <stdio.h>
#include <miscfunctions.h>
#include <countriesclass.h>

#define IDSTRING "PersonalWidget: "

//#define DEBUG_PERSONAL

PersonalWidget::PersonalWidget(CardPersonalElements *elements, QWidget *parent=0, const char *name=0) :
	PersonalWidgetBase(parent, name)
{
	setItems(elements);
}

CardPersonalElements *PersonalWidget::items()
{
	return _items;
}

void PersonalWidget::setItems(CardPersonalElements *_it)
{
	_items=_it;
	if(!_items)
		return;
#ifdef DEBUG_PERSONAL
	printf(IDSTRING"Setting up the fields (not NULL pointer)\n");
#endif
	// set up all the fields in the widget
	// card name
	// cardCombo->setEditText(nameToCard(items()->card()));
	// prefix (Mr, Miss...)
	prefixCombo->setEditText(items()->prefix());
	//family name
	familyEdit->setText(items()->familyName());
	//name
	nameEdit->setText(items()->name());
	//initial
	initialEdit->setText(items()->initial());
	//nick
	nickEdit->setText(items()->nick());
	//address
	poboxEdit->setText(items()->address().poBox());
	streetEdit->setText(items()->address().streetName());
	detailsEdit->setText(items()->address().details());
	codeEdit->setText(items()->address().code());
	cityEdit->setText(items()->address().city());
#ifdef DEBUG_PERSONAL
	printf(IDSTRING"Setting up the countries\n");
#endif
	QString myCountry = items()->address().country();
	countryBox->insertStringList(CountriesClass::thisInstance()->countries());
#ifdef DEBUG_PERSONAL
	printf(IDSTRING"Updating the country : <%s>\n", (const char *)myCountry);
#endif
	if(myCountry.stripWhiteSpace().isEmpty())
	{
		QStringList domains;
		if(items()->emails()->defaultEmail()!=-1 && items()->emails()->emails().count()!=0)
			domains=split(items()->emails()->emails()[items()->emails()->defaultEmail()], '.');
		if(domains.count()>1)
			myCountry=CountriesClass::thisInstance()->country(domains[domains.count()-1]);
		else
			myCountry="";
	}
#ifdef DEBUG_PERSONAL
	printf(IDSTRING"Updating the country : <%s>\n", (const char *)myCountry);
#endif
	updateComboBox(countryBox, myCountry);
	// email
	if(items()->emails()->defaultEmail()!=-1)
		emailsButton->setText(items()->emails()->emails()[items()->emails()->defaultEmail()]);
	else
		emailsButton->setText("No e-mails");
	// phone
	if(items()->phones().phones().count())
		homePhoneButton->setText(items()->phones().phones()[0]->number());
	else
		homePhoneButton->setText("No phones");
	// url
#ifdef DEBUG_PERSONAL
	printf(IDSTRING"URLs\n");
#endif
	urlBox->clear();
	if(items()->urls())
		urlBox->insertStringList(*(items()->urls()));
	clearUrlButton->setEnabled(items()->urls()->count()!=0);
}

/** The slots for changing stuff **/

void PersonalWidget::adrCityChanged(const QString &str)
{
	items()->address().setCity(str);
	emit(changedSignal());
}

void PersonalWidget::adrCodeChanged(const QString &str)
{
	items()->address().setCode(str);
	emit(changedSignal());
}

void PersonalWidget::adrCountryChanged(const QString &str)
{
	items()->address().setCountry(str);
	emit(changedSignal());
}

void PersonalWidget::adrDetailsChanged(const QString &str)
{
	items()->address().setDetails(str);
	emit(changedSignal());
}

void PersonalWidget::adrPoBoxChanged(const QString &str)
{
	items()->address().setPoBox(str);
	emit(changedSignal());
}

void PersonalWidget::adrStreetChanged(const QString &str)
{
	items()->address().setStreetName(str);
	emit(changedSignal());
}

void PersonalWidget::cardChanged(const QString &str)
{
	items()->setCard(cardToName(str));
	emit(changedSignal());
}

void PersonalWidget::familyChanged(const QString &str)
{
	items()->setFamilyName(str);
	items()->setCard(cardToName(cardCombo->currentText()));
	emit(changedSignal());
}

void PersonalWidget::nameChanged(const QString &str)
{
	items()->setName(str);
	items()->setCard(cardToName(cardCombo->currentText()));
	emit(changedSignal());
}

void PersonalWidget::urlChanged(const QString &str)
{
	if(items()->urls()->count() != urlBox->count() && 
			items()->urls()->grep(str).count()==0 && 
			!str.isEmpty())
	{
		items()->urls()->append(str);
		emit(urlUpdatedSignal(*items()->urls()));
	}
	if(items()->urls()->count())
		clearUrlButton->setEnabled(true);
	emit(changedSignal());
}

void PersonalWidget::nickChanged(const QString &str)
{
	items()->setNick(str);
	emit(changedSignal());
}

void PersonalWidget::prefixChanged(const QString &str)
{
	items()->setPrefix(str);
	items()->setCard(cardToName(cardCombo->currentText()));
	emit(changedSignal());
}

void PersonalWidget::initialChanged(const QString &str)
{
	items()->setInitial(str);
	items()->setCard(cardToName(cardCombo->currentText()));
	emit(changedSignal());
}

void PersonalWidget::showEmails()
{
	MailWidget *mw= new MailWidget(emailsButton, items()->emails(), this);
	mw->move(emailsButton->mapToGlobal(QPoint(0,25)));
	mw->show();
}

void PersonalWidget::showHomePhones()
{
	PhoneWidget *pw= new PhoneWidget(homePhoneButton, &(items()->phones()), this);
	pw->move(homePhoneButton->mapToGlobal(QPoint(0,25)));
	pw->show();
}

void PersonalWidget::clearUrl()
{
	int idx=-1;
	for(int i=0;i<urlBox->count();i++)
		if(urlBox->text(i)==urlBox->currentText())
		{
			idx=i;
			i=urlBox->count();
		}
	urlBox->setEditText("");
	if(idx!=-1)
	{
		// erase the element
		urlBox->removeItem(idx);
	}
	if(urlBox->count())
		urlBox->setCurrentItem(0);
	else
		clearUrlButton->setEnabled(false);
	QStringList result;
	for(int i=0;i<urlBox->count();i++)
		result.append(urlBox->text(i));
	emit(changedSignal());
	emit(urlUpdatedSignal(result));
}

void PersonalWidget::urlUpdated(const QStringList &l)
{
	urlBox->clear();
	urlBox->insertStringList(l);
}

QString PersonalWidget::nameToCard(QString str)
{
	QString result=str.simplifyWhiteSpace();
	int index;
	index=result.find(items()->familyName(), 0, true);
	if(index!=-1 && !items()->prefix().isEmpty())
		result.replace(index, items()->prefix().length(), "Prefix");
	index=result.find(items()->familyName(), 0, true);
	if(index!=-1 && !items()->familyName().isEmpty())
		result.replace(index, items()->familyName().length(), "Surname");
	index=result.find(items()->name(), 0, true);
	if(index!=-1 && !items()->name().isEmpty())
		result.replace(index, items()->name().length(), "Name");
	index=result.find(items()->initial(), 0, true);
	if(index!=-1 && !items()->initial().isEmpty())
		result.replace(index, items()->prefix().length(), "Initial");
	return result;
}

QString PersonalWidget::cardToName(QString str)
{
	QString result=str.simplifyWhiteSpace();
	int index;
	index=result.find("Prefix", 0, true);
	if(index!=-1) result.replace(index, 6, items()->prefix());
	index=result.find("Surname", 0, true);
	if(index!=-1) result.replace(index, 7, items()->familyName());
	index=result.find("Name",0,true);
	if(index!=-1) result.replace(index, 4, items()->name());
	index=result.find("Initial",0,true);
	if(index!=-1) result.replace(index, 7, items()->initial());
	return result;
}

