/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_SETUP_NOTES
	#define HAS_SETUP_NOTES

#include <qlabel.h>
#include <qscrollbar.h>
#include <qlineedit.h>
#include <qcolor.h>
#include <etogglebutton.h>
#include <qmainwindow.h>


class ColorsDialog : public QMainWindow
{
	Q_OBJECT
public:
	ColorsDialog(QWidget *parent=0, QString name=QString::null,
		QString deColor="yellow");
	
signals:
	void done(QString color);
	
private slots:
	void redClicked(bool);
	void greenClicked(bool);
	void blueClicked(bool);
	void yellowClicked(bool);
	void cancelClicked();
	
private:
	QString color, oldColor;
	EToggleButton *red;
	EToggleButton *green;
	EToggleButton *blue;
	EToggleButton *yellow;
	QPushButton *cancel;
};


class NotesSetupWidget : public QFrame
{
	Q_OBJECT
public:
	NotesSetupWidget(QWidget *p=0, 
		QString *c=0, QFont *f=0, QSize *s=0, QString n=QString::null);
	QFont getFont();
	QColor getColor();
	QSize getSize();

public slots:
	void sizeButtonPressed();
	void colorButtonPressed();
	void fontButtonPressed();
	void sizeDialogEnded(QStringList);
	void colorDialogEnded(QString);
	
protected:

	// Methods
	void setupWidget();
	QPixmap generateColorPixmap(QString col);

	// title
	QLabel *titleLabel;
	// Size
	QLabel *sizeLabel;
	EButton *sizeButton;
	// Color
	QLabel *colorLabel;
	EButton *colorButton;
	// Font
	QLabel *fontLabel;
	EButton *fontButton;
	// separating frames
	QFrame *frame1;
	QFrame *frame2;
	QFrame *frame3;
	/* The variables */
	QFont font;
	QSize size;
	QString color;
};

#endif
