/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qstringlist.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qregexp.h>
#include <qlistbox.h>
#include <qheader.h>
#include <qdatastream.h>
#include <qcstring.h>

#include <addressbookdialog.h>
#include <addressbookview.h>
#include <ataddressbook.h>
#include <addresslineedit.h>
#include <addressclass.h>
#include <miscfunctions.h>
#include <stdio.h>

#define IDSTRING "AddressBookDialog: "

//#define DEBUG_ABD

// First overwrite the dialog's style to MODAL!
AddressBookDialog::AddressBookDialog(QWidget *parent, const char * name) :
	AddressBookDialogBase(parent, name, true)
{
	_members.clear();
	addressBookView->initMode(AddressBook::Contacts | AddressBook::Groups);
	addressLineEdit->initMode(AddressBook::Contacts |
			AddressBook::Groups |
			AddressBook::History);
	membersListView->header()->hide();
}
void AddressBookDialog::initDialog(QStringList &m)
{
	setMembers(m);
	for(int i=0;i<m.count();i++)
	{
		QListViewItem *item;
		item=new QListViewItem(membersListView);
		QCString s=(const char *)m[i];
		AddressClass *ac= new AddressClass(s);
		item->setText(0,(const char *)ac->translated_name);
		item->setText(1,(const char *)ac->email);
		item->setText(2,m[i]);
		membersListView->insertItem(item);
#ifdef DEBUG_ABD
		printf("-------------- adding \n");
#endif
		delete ac;
	}
}
QStringList &AddressBookDialog::members()
{
	return _members;
}
void AddressBookDialog::setMembers(QStringList &m)
{
	_members=oldMembers=m;
}
void AddressBookDialog::addressBook(QStringList &list, QString text, QWidget *parent)
{
	AddressBookDialog *abd=new AddressBookDialog(parent);
	abd->initDialog(list);
	if(text)
		abd->setCaption(text);
	abd->show();
	list=abd->members();
}

void AddressBookDialog::addAddressBookClicked()
{
	QStringList newItems;
	addressBookView->getSelectedEmailList(newItems);
	addItems(newItems);
}

bool AddressBookDialog::isMember(QString str)
{
	QListViewItemIterator it(membersListView);
	QCString s=(const char *)str;
	AddressClass ac(s);
	while(it.current())
	{
		QListViewItem *item=it.current();
		if(item->text(1)==QString(ac.email))
		{
#ifdef DEBUG_ABD
		printf(" DUPLICATED %s\n", (const char *)str);
#endif
			return true;
		}
		++it;
	}
	return false;
}

void AddressBookDialog::addItems(QStringList &list)
{
	QStringList duplicatedItems;
	// now let's check the members...
	for(int i=0;i<list.count();i++)
	{
		if(isMember(list[i]))
		{
#ifdef DEBUG_ABD
		printf("Duplicated item: \"%s\"\n",(const char *)list[i]);
			duplicatedItems.append(list[i]);
#endif
		}
		else
		{
			QListViewItem *item;
			item=new QListViewItem(membersListView);
			QCString s=(const char *)list[i];
			AddressClass *ac= new AddressClass(s);
			item->setText(0,(const char *)ac->translated_name);
			item->setText(1,(const char *)ac->email);
			item->setText(2,list[i]);
			membersListView->insertItem(item);
			delete ac;
		}
	}
	membersListView->sort();
#ifdef DEBUG_ABD
	if(duplicatedItems.count())
	{
		printf("AddressBookDialog::addAddressBookClicked: you have duplicatedItems "
			"to play with if you want.\n");
	}
#endif
	if(membersListView->childCount())
		okButton->setEnabled(true);
}

void AddressBookDialog::addAddressesClicked()
{
	QStringList newItems;
	QStringList its= QStringList::split(QRegExp("[,;]"), addressLineEdit->lineEdit()->text());
	for(int i=0;i<its.count();i++)
	{
		newItems=AddressBook::thisInstance()->getRealEntry(its[i].stripWhiteSpace());
#ifdef DEBUG_ABD
		printf("<%s> vs  <%s>\n", (const char *)its[i], (const char *)newItems[0]);
#endif
		if(newItems.count()==0)
		{
			//to add in cache a new address
			QString txt=its[i].stripWhiteSpace();
			if(txt.find("@")!=-1)
			{
				AddressBook::thisInstance()->addHistoryAddress(txt);
				newItems.append(txt);
				addItems(newItems);
			}
		}
		else
		{
			addItems(newItems);
		}
	}
}
void AddressBookDialog::cancelClicked()
{
	_members=oldMembers;
}
void AddressBookDialog::removeClicked()
{
	QListViewItemIterator it(membersListView);
	while(it.current())
	{
		if(it.current()->isSelected())
		{
			membersListView->takeItem(it.current());
		}
		++it;
	}
}
void AddressBookDialog::okClicked()
{
	_members.clear();
	QListViewItemIterator it(membersListView);
	while(it.current())
	{
		_members.append(it.current()->text(2));
		++it;
	}
}
