/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __PartObject__
#define __PartObject__

#include <vobject.h>
#include <vobjectfactory.h>
#include <queryprocessor.h>
#include <qstring.h>

class PartObject : public VObject
{
	friend class ClientVFS;
	protected:
		PartObject(QString _path, QByteArray &_data);
		PartObject(QString _path);
	public:
		QString filename();
		void setFilename(const QString &);
		QString mimeType();
		void setMimeType(const QString &);
		QString contentID();
		void setContentID(const QString &);
		QString partType();
		void setPartType(const QString &);
		QString encoding();
		void setEncoding(const QString &);
		
		// object marshalling methods
		bool sync();
		bool save();
		
		// query handling
		virtual bool getProperty(const QString &query, Any &property);
		virtual bool setProperty(const QString &query, Any &property);
		virtual QueryProcessor::QueryType queryType(const QString &query);
	protected:
		QString _filename;
		QString _mimeType;
		QString _contentID;
		QString _partType;
		QString _encoding;
};

class PartObjectFactory : public VObjectFactory
{
	public:
		PartObject *_new(QString _path, QByteArray &_data);
		PartObject *_new(QString _path);
};

#endif
