#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include <imap4wizardbase.h>
#include <imap4wizard.h>

#include <accountsconfig.h>

IMAP4Wizard::IMAP4Wizard(AccountsConfig::Account *a, QWidget *parent, const char *name=0) :
	IMAP4WizardBase(parent, name, true)
{
	//eliminating the "Help" button temporarely
	helpButton()->hide();
	setNextEnabled(userInfo, false);
	setNextEnabled(imap4Widget, false);
	
	element=a;
	if(!element)
		close();
}
void IMAP4Wizard::emailChanged(const QString &str)
{
	setNextEnabled(userInfo, str.length()>0 && element->name.length()>0);
	element->from=str;
}

void IMAP4Wizard::leaveClicked()
{
	element->leaveOnServer=leaveCheck->isChecked();
}

void IMAP4Wizard::nameChanged(const QString &str)
{
	setNextEnabled(userInfo, str.length()>0 && element->from.length()>0);
	element->name=str;
}

void IMAP4Wizard::smtpPortChanged(const QString &str)
{
	element->SMTPport=str.toInt();
	setFinishEnabled(SMTP, element->SMTPport);
}

void IMAP4Wizard::passChanged(const QString &str)
{
	element->passwd=str;
}

void IMAP4Wizard::passClicked()
{
	passEdit->setEnabled(passCheck->isChecked());
	element->rememberPasswd=passCheck->isChecked();
	if(element->rememberPasswd)
		element->passwd=passEdit->text();
	else
		element->passwd="";
}

void IMAP4Wizard::imap4Changed(const QString &str)
{
	setNextEnabled(imap4Widget, str.length()>0);
	element->Server=str;
}

void IMAP4Wizard::imap4PortChanged(const QString &str)
{
	element->port=str.toInt();
	setNextEnabled(imap4Widget, element->port);
}

void IMAP4Wizard::replyChanged(const QString &str)
{
	element->replyTo=str;
}

void IMAP4Wizard::smtpChanged(const QString &str)
{
	setFinishEnabled(SMTP, str.length()>0);
	element->SMTPServer=str;
}

void IMAP4Wizard::userChanged(const QString &str)
{
	element->user=str;
}

void IMAP4Wizard::accountNameChanged(const QString &str)
{
	setNextEnabled(userInfo, str.length());
	element->accountName=str;
	setCaption(QString("Create a new IMAP4 account")+ (str.length()?": ":".") + str);
}

void IMAP4Wizard::sortClicked()
{
	element->sort=sortCheck->isChecked();
}

void IMAP4Wizard::syncClicked()
{
	element->sync=syncCheck->isChecked();
}


void IMAP4Wizard::accept()
{
	element->type="IMAP4";
	element->enabled=true;
	element->persistence=-1;
	element->sync=true;
 	if(element->accountName.contains('.'))
 		element->accountName=element->accountName.replace(QRegExp("\\."),"_");
	element->port=portEdit->text().toInt();
	element->SMTPport=smtpPortEdit->text().toInt();
	QDialog::accept();
}

void IMAP4Wizard::reject()
{
	element->SMTPServer = element->Server = "";
	QDialog::reject();
}


