/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <htmlconfig.h>
#include <qcheckbox.h>
#include <qstring.h>
#include <qstringlist.h>
#include <kconfig.h>
#include <stdio.h>

extern KConfig *GlobalConfig;


HtmlConfig::HtmlConfig(QWidget *parent, const char * name=0) : HtmlConfigBase(parent, name)
{
	load();
}

void HtmlConfig::load()
{
	enhance=reply=preferText=rules=textOnly=wrote=false;
	GlobalConfig->setGroup("HTML Parser");
	QStrList values;
	
	enhance=GlobalConfig->readEntry("Enable enhancers")=="Yes";
	enhanceCheck->setChecked(enhance);
	GlobalConfig->readListEntry("Enhancers list", values);
	printf("Loaded %d enhancers\n", values.count());
	if(values.count()!=0)
	{
		if(values.find("Wrote")!=-1) wrote=true;
		if(values.find("Reply")!=-1) reply=true;
		if(values.find("Rules")!=-1) rules=true;
	}
	enhanceModified(enhance);
	preferText=GlobalConfig->readEntry("Text preferred")=="Yes";
	preferTextCheck->setChecked(preferText);
	textOnly=GlobalConfig->readEntry("Text only")=="Yes";
	textOnlyCheck->setChecked(textOnly);
	addresses=GlobalConfig->readEntry("Web address detection")=="Yes";
	addressesCheck->setChecked(addresses);
}

void HtmlConfig::sync(bool visible=false)
{
	bool doSync=(!visible && isVisible()) | (visible);
	if(doSync)
	{
		GlobalConfig->setGroup("HTML Parser");
		// the rules
		QStringList values;
		printf(" Saving rules: %d %d %d\n", wrote, reply, rules);
		if(wrote)	values.append("Wrote");
		if(reply)	values.append("Reply");
		if(rules) values.append("Rules");
		GlobalConfig->writeEntry("Enable enhancers", ((enhance)?QString("Yes"):QString("No")));
		GlobalConfig->writeEntry("Enhancers list", values); 
		GlobalConfig->writeEntry("Text only", ((textOnly)?QString("Yes"):QString("No")));
		GlobalConfig->writeEntry("Text preferred", ((preferText)?QString("Yes"):QString("No")));
		GlobalConfig->writeEntry("Web address detection", ((addresses)?QString("Yes"):QString("No")));
		emit(noChanged());
	}
}

void HtmlConfig::addressesChanged()
{
	addresses=addressesCheck->isChecked();
	emit(changed());
}

void HtmlConfig::enhanceChanged()
{
	enhance=enhanceCheck->isChecked();
	enhanceModified(enhance);
	emit(changed());
}

void HtmlConfig::replyChanged()
{
	reply=replyCheck->isChecked();
	emit(changed());
}

void HtmlConfig::preferTextChanged()
{
	preferText=preferTextCheck->isChecked();
	emit(changed());
}

void HtmlConfig::rulesChanged()
{
	rules=rulesCheck->isChecked();
	emit(changed());
}

void HtmlConfig::textOnlyChanged()
{
	textOnly=textOnlyCheck->isChecked();
	emit(changed());
}

void HtmlConfig::wroteChanged()
{
	wrote=wroteCheck->isChecked();
	emit(changed());
}


void HtmlConfig::enhanceModified(bool enh)
{
	replyCheck->setEnabled(enh);
	replyCheck->setChecked(enh & reply);
	wroteCheck->setEnabled(enh);
	wroteCheck->setChecked(enh & wrote);
	rulesCheck->setEnabled(enh);
	rulesCheck->setChecked(enh & rules);
}

