/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __Has_AddressBook__
#define __Has_AddressBook__

#include <qstringlist.h>
#include <qdict.h>
#include <contactobj.h>
#include <groupobj.h>


class AddressBook
{
  public:
		enum { Contacts=1, Groups=2, History=4, ListOnly=8 , ShowHeader=0x10};	

     // scans contacts, groups, loads history
    AddressBook();

    // scans all contacts and calls addContact()
    void scanContacts(); 
    // scans all groups and call addGroup()
    void scanGroups(); 

    /*
		 * load history from file, calls addHistoryAddress()
		 * save history to file
		 * adding the history address to the cache
		 */
    void loadHistory(); 
    void saveHistory();
		void addHistoryAddress(QString address);
		
		void addContact(ContactObject *);
		void addGroup(GroupObject *);
    // remove url from contactURLs and add all emails 
		// (properly formatted if necessary) to
		// history
    void removeContact(QString url); 
    // remove url from groupURLs and add all emails to history
    void removeGroup(QString url); 

    QStringList &getContacts(); // return contactURLs
    QStringList &getGroups(); // return groupURLs
    QStringList &getHistory(); // returs historyAddresses
		
		void removeHistoryItem(QString);
    
		// scan "entries" with a dict iterator and build list of matching entries 
    // (matching means that substring
		// (first input_string.length() chars of key)==
		//					(case insensitive)input_string)
    QStringList completeNames(QString key, int mode=Contacts|Groups|History);
		QString getDefaultName(QString key); 
		QStringList complete(QString key);
		QStringList getEntries(QStringList keys);
		QStringList getEntry(QString key);
		QStringList getRealEntry(QString key);
		static AddressBook *thisInstance();
		
		// returns a group by its url
		GroupObject *getGroupByUrl(QString);
		GroupObject *getGroupByName(QString);
		
		// checks if it's a group or a contact
		bool isGroup(QString);
		bool isContact(QString);
		
  private:
		QString makeProper(ContactObject *, QString);
		// Use the QDict to complete names...
		QStringList completeNamesContacts(QString key);
		QStringList completeNamesGroups(QString key);
		QStringList completeNamesHistory(QString key);
		bool isProper(QString &addr);
		
		void addUnique(QStringList &, QString entry);
		// url -> email
    QDict<QString> entries;
		// entries -> url
    QDict<QStringList> aliasesDict;
		QDict<QStringList> reverse;
		// there is no point in doing a history dict really...
		QStringList contacts, groups, historyAddresses;
		QDict<GroupObject> go;
		int historySize;
		static AddressBook *item;
};

#endif
