# include <tcl.h>

# include "tclhfs.h"

/*
 * NAME:	Tcl->AppInit()
 * DESCRIPTION:	initialize interpreter
 */
int Tcl_AppInit(Tcl_Interp *interp)
{
  if (Tcl_Init(interp) == TCL_ERROR)
    return TCL_ERROR;

  if (Hfs_Init(interp) == TCL_ERROR)
    return TCL_ERROR;

  return TCL_OK;
}

/*
 * NAME:	main()
 * DESCRIPTION:	program entry
 */
int main(int argc, char *argv[])
{
  Tcl_Main(argc, argv, Tcl_AppInit);

  return 0;  /* not reached */
}
