/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@medizin.uni-ulm.de
 *
 *  RCS: $Header: memory.h,v 1.2 94/05/06 15:59:50 nau Exp $
 */

/* prototypes for memory routines
 */

#ifndef	__MEMORY_INCLUDED__
#define	__MEMORY_INCLUDED__

#include <stdlib.h>
#include "global.h"

/* ---------------------------------------------------------------------------
 * some memory types
 */
typedef struct
{
	size_t	MaxLength;
	char	*Data;
} DynamicStringType, *DynamicStringTypePtr;

void	*MyCalloc(size_t, size_t, char *);
void	*MyRealloc(void *, size_t, char *);
char	*MyStrdup(char *s, char *);
void	MyFree(char **);
void	FreeElementMemory(ElementTypePtr);
void	FreePCBMemory(PCBTypePtr);
void	SaveFree(void *);
void	DSAddCharacter(DynamicStringTypePtr, char);
void	DSAddString(DynamicStringTypePtr, char *);

#endif
