/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@medizin.uni-ulm.de
 *
 *  RCS: $Header: action.h,v 1.1 94/04/26 20:07:13 nau Exp $
 */

/* prototypes for action routines
 */

#ifndef	__ACTION_INCLUDED__
#define	__ACTION_INCLUDED__

#include "global.h"

void	ActionMovePointer(Widget, XEvent *, String *, Cardinal *);
void	ActionSetCursor(Widget, XEvent *, String *, Cardinal *);
void	ActionSetSetting(Widget, XEvent *, String *, Cardinal *);
void	ActionCreate(Widget, XEvent *, String *, Cardinal *);
void	ActionRemove(Widget, XEvent *, String *, Cardinal *);
void	ActionMode(Widget, XEvent *, String *, Cardinal *);
void	ActionBlock(Widget, XEvent *, String *, Cardinal *);
void	ActionRotateElement(Widget, XEvent *, String *, Cardinal *);
void	ActionChange(Widget, XEvent *, String *, Cardinal *);
void	ActionRedraw(Widget, XEvent *, String *, Cardinal *);
void	ActionCenter(Widget, XEvent *, String *, Cardinal *);
void	ActionGrabElement(Widget, XEvent *, String *, Cardinal *);
void	ActionName(Widget, XEvent *, String *, Cardinal *);
void	ActionEndCommand(Widget, XEvent *, String *, Cardinal *);
void	ActionText(Widget, XEvent *, String *, Cardinal *);
void	ActionConnection(Widget, XEvent *, String *, Cardinal *);
void	ActionElementNameMode(Widget, XEvent *, String *, Cardinal *);
void	ActionStartCommand(Widget, XEvent *, String *, Cardinal *);
void	ActionLineStack(Widget, XEvent *, String *, Cardinal *);
void	ActionDisplayPinout(Widget, XEvent *, String *, Cardinal *);

#endif
