.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP DATABASE" "" "2008-09-19" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP DATABASE \- remove a database

.SH SYNOPSIS
.sp
.nf
DROP DATABASE [ IF EXISTS ] \fIname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP DATABASE\fR drops a database. It removes the
catalog entries for the database and deletes the directory
containing the data. It can only be executed by the database owner.
Also, it cannot be executed while you or anyone else are connected
to the target database. (Connect to postgres or any
other database to issue this command.) 
.PP
\fBDROP DATABASE\fR cannot be undone. Use it with care!
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the database does not exist. A notice is issued 
in this case.
.TP
\fB\fIname\fB\fR
The name of the database to remove.
.SH "NOTES"
.PP
\fBDROP DATABASE\fR cannot be executed inside a transaction
block.
.PP
This command cannot be executed while connected to the target
database. Thus, it might be more convenient to use the program
dropdb [\fBdropdb\fR(1)] instead,
which is a wrapper around this command.
.SH "COMPATIBILITY"
.PP
There is no \fBDROP DATABASE\fR statement in the SQL standard.
.SH "SEE ALSO"
CREATE DATABASE [\fBcreate_database\fR(l)]
