<?php

/**************************************************
Program name:	get_array_tables.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of table names, owner, comments.
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/


// SQL string to get list of tables
$sql_get = "
	SELECT 
		c.relname as ".dquotes($strTable).",
		u.usename as ".dquotes($strOwner).",
		obj_description(c.oid) as ".dquotes($strDescription)."
	FROM 
		pg_class c, pg_user u
	WHERE
		c.relowner = u.usesysid AND c.relkind = 'r'
		AND c.relname !~ '^pg_'
	UNION
	SELECT 
		c.relname as tablename,
		NULL as tableowner,
		obj_description(c.oid) as description
	FROM
		pg_class c
	WHERE 
		c.relkind = 'r'
		AND not exists (select 1 from pg_user where usesysid = c.relowner)
		AND c.relname !~ '^pg_'
	";


// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");


// Modify Array
for ($i = 0; $i < $num_rows; $i++) {

	// Count values of Table
	if ($cfgCountRecs) { 
		$Extra_Column_Value[$i][0] = count_records($link, $sql_array[$i][0]);
	}
	
	If ($Extra_Column_Value[$i][0] == 0) {
		$Extra_Column_Value[$i][0] = "0";
	}

	// Make array table names
	$aryTables[$i] = $sql_array[$i][0];

	// Change Tablename into a link
	$sql_array[$i][0] = "<a class=link href=tbl_properties.php?ntable=".$sql_array[$i][0].">".$sql_array[$i][0]."</a>";
}


?>
