/*
 * User.java
 *
 * Created on 30 de julio de 2002, 16:04
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.sql.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class User extends DBObject {
    private String password = new String();
    private boolean user_createDB = false;
    private boolean user_trace = false;
    private boolean user_super = false;
    private boolean user_captupd = false;
    private java.util.Date user_valuntil = null;
    private long sysID = -1;
    
    /** Creates a new instance of User */
    public User(DBObject _owner, String _name) {
        super(_owner);
        search(_name);
    }
    public User(DBObject _owner, long _sysID) {
        super(_owner);
        search(_sysID);
    }
    public User(DBObject _owner) {
        super(_owner);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP USER ");
        retorno.append(getName());
        retorno.append(";\n ");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE USER ");
        retorno.append(getName()).append(" ");
        if((getPassword().length() > 0) || (isDBCreateor())
        || (isSuperUser()) || (getValidLimit()!= null)){
            retorno.append("WITH ");
            if((getPassword().length() > 0)){
                retorno.append("PASSWORD '").append(getPassword()).append("' \n");
            }
            if(isDBCreateor()){
                retorno.append("CREATEDB ");
            }
            if(isSuperUser()){
                retorno.append("CREATEUSER ");
            }
            if(getValidLimit()!= null){
                retorno.append("VALID UNTIL '").append(Utilities.formatDate(getValidLimit(), "MMM d yyyy")).append("' ");
            }
        }
        retorno.append(";\n");
        return retorno.toString();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the OID.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        try{
            initialize();
            ResultSet rs = getConnection().getQueryGenerator().getUser(_name);
            storeData(rs);
            retorno = true;
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;
    }
    /** Find the object asociated with the OID.
     * @return true if the object was found
     */
    public boolean search(long _sysid) {
        boolean retorno = false;
        try{
            initialize();
            ResultSet rs = getConnection().getQueryGenerator().getUser(_sysid);
            storeData(rs);
            retorno = true;
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;
    }
    private void storeData(ResultSet rs) throws SQLException{
        if ((rs != null) && (rs.next())){
            setName(rs.getString("USER_NAME"));
            sysID = rs.getLong("USER_SYSID");
            setDBCreator(rs.getBoolean("USER_DBCREATOR"));
            setTraceUser(rs.getBoolean("USER_DBCREATOR"));
            setSuperUser(rs.getBoolean("USER_DBCREATOR"));
            setCanUpdateSystemCatalog(rs.getBoolean("USER_DBCREATOR"));
            setValidLimit(rs.getTimestamp("USER_LIMITDATE"));
        }
    }
    
    
    public void initialize(){
        super.initialize();
        password = new String();
        user_createDB = false;
        user_trace = false;
        user_super = false;
        user_captupd = false;
        user_valuntil = null;
    }
    
    // ------ SET AND GET --------
    public void setPassword(String _password){
        if(_password != null){
            password = _password;
        } else {
            password = new String();
        }
    }
    private String getPassword(){
        return password;
    }
    
    public boolean isDBCreateor(){
        return user_createDB;
    }
    public void setDBCreator(boolean _user_createDB){
        user_createDB = _user_createDB;
    }
    
    public boolean isTraceUser(){
        return user_trace;
    }
    public void setTraceUser(boolean _user_trace){
        user_trace = _user_trace;
    }
    
    public boolean isSuperUser(){
        return user_super;
    }
    public void setSuperUser(boolean _user_super){
        user_super = _user_super;
    }
    
    public boolean canUpdateSystemCatalog(){
        return user_captupd;
    }
    public void setCanUpdateSystemCatalog(boolean _user_captupd){
        user_captupd = _user_captupd;
    }
    
    public java.util.Date getValidLimit(){
        return user_valuntil;
    }
    public void setValidLimit(java.util.Date _until){
        if(_until != null){
            user_valuntil = _until;
        } else {
            user_valuntil = null;
        }
    }
    public void setValidLimit(java.sql.Timestamp _until){
        if(_until != null){
            user_valuntil = new java.sql.Date(_until.getTime());
        } else {
            user_valuntil = null;
        }
    }
    
    /** refresh the data from database.
     */
    public void refresh() {
        search(getName());
    }
    
}
