/*
 * TableIndex.java
 *
 * Created on 31 de julio de 2002, 10:09
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.sql.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class TableIndex extends DBObject {
    private boolean clustered = false;
    private boolean keytype = false;
    private boolean unique = false;
    private boolean primary = false;
    private Vector columns = null;
    private String description = null;
    
    /** Creates a new instance of TableIndex */
    public TableIndex(DBObject owner, String _name) {
        super(owner);
        search(_name);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer(50);
        retorno.append(" DROP INDEX ");
        retorno.append(getName()).append(";\n");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        if(isPrimary()){
            retorno.append("CONSTRAINT ");
            retorno.append(getName());
            retorno.append(" PRIMARY KEY (");
            retorno.append(getColumnsText());
            retorno.append(" ) \n");
        } else {
            retorno.append("CREATE ");
            if(isUnique()){
                retorno.append("UNIQUE ");
            }
            retorno.append("INDEX ");
            retorno.append(getName());
            retorno.append(" ON ");
            retorno.append(getOwner().getName());
            retorno.append(" ( ");
            retorno.append(getColumnsText());
            retorno.append(" ); \n");
        }
        retorno.append(getCommentSQL());
        return retorno.toString();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the Name.
     * @param _name Table Index name to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        try{
            ResultSet rs = getConnection().getQueryGenerator().getIndex(_name);
            if((rs != null) && (rs.next())){
                setName(rs.getString("INDEX_NAME"));
                setClustered(rs.getBoolean("INDEX_CLUSTER"));
                setHasKeyType(rs.getBoolean("INDEX_HASH"));
                setUnique(rs.getBoolean("INEDEX_UNIQUE"));
                setPrimary(rs.getBoolean("INDEX_PRIMARY"));
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;
    }
    
    public void initialize(){
        super.initialize();
        clustered = false;
        keytype = false;
        unique = false;
        primary = false;
        columns = null;
        description = null;
    }
    
    
    // -----SET AND GET-------
    public Vector getColumns(){
        if(columns == null){
            columns = new Vector();
            try{
                ResultSet rs = getConnection().getQueryGenerator().getColumnNames(getName());
                while((rs != null) && rs.next()){
                    TableColumn tc = new TableColumn(this, rs.getString("COLUMN_NAME")); 
                    columns.add(tc);
                }
                rs.close();
                rs.getStatement().close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return columns;
    }
    public String getColumnsText(){
        StringBuffer retorno = new StringBuffer();
        for(int i=0; i<getColumns().size(); i++){
            TableColumn tc = (TableColumn) columns.get(i);
            retorno.append(tc.getName());
            if(i<columns.size()-1){
                retorno.append(", ");
            }
        }
        return retorno.toString();
    }
    public int getColumnIndex(String _column_name){
        _column_name = _column_name.toUpperCase();
        int retorno = -1;
        if(_column_name != null){
            for(int i=0; (i<getColumns().size()) && (retorno < 0) ; i++){
                TableColumn tc = (TableColumn) columns.get(i);
                if(tc.getName().toUpperCase().equals(_column_name)) {
                    retorno = i;
                }
            }
        }
        return retorno;
    }
    
    public boolean isClustered(){
        return clustered;
    }
    public void setClustered(boolean _clustered){
        clustered = _clustered;
    }
    private void setHasKeyType(boolean _keytype){
        keytype = _keytype;
    }
    public boolean hasKeyType(){
        return keytype;
    }
    public boolean isUnique(){
        return unique;
    }
    public void setUnique(boolean _unique){
        unique = _unique;
    }
    
    public boolean isPrimary(){
        return primary;
    }
    public void setPrimary(boolean _primary){
        primary = _primary;
    }
    
    public String getDescription(){
        if(description == null){
            description = getConnection().getQueryGenerator().getTableDescription(getName());
        }
        return description;
    }
    
    private String getCommentSQL(){
        String retorno = new String();
        if(getDescription().length() > 0){
            retorno = "COMMENT ON INDEX " + getName() 
                        + " IS '" + getDescription() + "'; \n";
        }
        return retorno;
    }
    
    protected void setDescription(String _description){
        if(_description != null){
            description = _description;
        } else {
            description = new String();
        }
    }
    /** refresh the data from database.
     * if oid>0. Elsewere no action.
     */
    public void refresh() {
        search(getName());
    }
}

