/*
 * PrincipalFrameMenu.java
 *
 * Created on 18 de julio de 2002, 16:38
 */

package frames;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
/**
 *
 * @author  nestor
 */
public class PrincipalFrameMenu extends JMenuBar{
    JMenuItem disconnect = null;
    JMenuItem sql_wind = null;
    JMenuItem vacuum = null;
    PrincipalFrame frame = null;
    
    /** Creates a new instance of PrincipalFrameMenu */
    public PrincipalFrameMenu(PrincipalFrame _frame) {
        frame = _frame;
        
// FILE
        JMenu file = new JMenu("File");
        file.setMnemonic(KeyEvent.VK_F);
        add(file);
        
        JMenuItem connect = new JMenuItem("Connect...");
        connect.setMnemonic(KeyEvent.VK_X);
        connect.setActionCommand(PrincipalFrameListener.AC_CONNECT);
        connect.addActionListener(frame.getListener());
        file.add(connect);
        disconnect = new JMenuItem("Disconnect");
        disconnect.setActionCommand(PrincipalFrameListener.AC_DISCONNECT);
        disconnect.addActionListener(frame.getListener());
        file.add(disconnect);
        
        file.addSeparator();
        
        JMenuItem exit = new JMenuItem("Exit");
        exit.setMnemonic(KeyEvent.VK_X);
        exit.setActionCommand(PrincipalFrameListener.AC_EXIT);
        exit.addActionListener(frame.getListener());
        file.add(exit);
        
// TOOLS
        JMenu tools = new JMenu("Tools");
        tools.setMnemonic(KeyEvent.VK_T);
        add(tools);
        sql_wind = new JMenuItem("SQL Window");
        sql_wind.setMnemonic(KeyEvent.VK_S);
        sql_wind.setActionCommand(PrincipalFrameListener.AC_SQL_WINDOW);
        sql_wind.addActionListener(frame.getListener());
        tools.add(sql_wind);
        
        vacuum = new JMenuItem("Vacuum Database");
        vacuum.setMnemonic(KeyEvent.VK_V);
        vacuum.setActionCommand(PrincipalFrameListener.AC_VACUUM);
        vacuum.addActionListener(frame.getListener());
        tools.addSeparator();
        tools.add(vacuum);
        
        
// SETUP
        JMenu setup = new JMenu("Setup");
        setup.setMnemonic(KeyEvent.VK_S);
        setup.setMinimumSize(setup.getPreferredSize());
        add(setup);
        
        JMenuItem save_options = new JMenuItem("Save Options");
        save_options.setMnemonic(KeyEvent.VK_S);
        save_options.setActionCommand(PrincipalFrameListener.AC_SAVE_OPTIONS);
        save_options.addActionListener(frame.getListener());
        setup.add(save_options);
        JMenuItem restore_options = new JMenuItem("Restore Options");
        restore_options.setMnemonic(KeyEvent.VK_R);
        restore_options.setActionCommand(PrincipalFrameListener.AC_RESTORE_OPTIONS);
        restore_options.addActionListener(frame.getListener());
        setup.add(restore_options);
        
        add(Box.createHorizontalGlue());

// HELP
        JMenu help = new JMenu("Help");
        help.setMnemonic(KeyEvent.VK_H);
        help.addActionListener(frame.getListener());
        add(help);
    }
    
    public void refreshValidation(){
        if(frame != null){
            boolean valid = frame.getDatabase().validate();
            disconnect.setEnabled(valid);
            sql_wind.setEnabled(valid);
            vacuum.setEnabled(valid);
        }
    }
}

