/*
 * DatabaseList.java
 *
 * Created on 31 de julio de 2002, 10:59
 */

package pgclibrary.treeObjects;
import java.sql.*;
import java.util.*;
import pgclibrary.objects.*;
/**
 *
 * @author  nestor
 */
public class DatabaseList extends TreeInfo {
    /** Creates a new instance of DatabaseList */
    public DatabaseList(RootElement source) {
        super(source);
        setIcon("/images/database.gif");
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            PreparedStatement prep = getConnection().prepareStatement("SELECT DATNAME FROM pg_database ORDER BY DATNAME");
            ResultSet rs = prep.executeQuery();
            while(rs.next()){
                addProperty(new Element(this, new Database(getConnection(), rs.getString("DATNAME"))));
            }
            rs.close();
            prep.close();
        } catch (SQLException e){}
    }
    
    public Object getOID() {
        return toString();
    }
    
    public String toString(){
        return "Databases";
    }
}

