/*
 * PrincipalFrameComponent.java
 *
 * Created on 18 de julio de 2002, 15:46
 */

package frames;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import components.*;
import pgclibrary.objects.*;
import components.*;
import components.table.*;
import components.group.*;
import components.view.*;
import components.database.*;
import components.sequence.*;
import components.user.*;
import pgclibrary.dataaccess.*;
import pgclibrary.treeObjects.*;

/**
 *
 * @author  nestor
 */
public class PrincipalFrameComponent extends JSplitPane {
    private PrincipalFrame frame = null;
    private TreeControl tree_control = null;
    
    private TreeInfo last_selected = null;
    private CreditsPanel default_panel = new CreditsPanel();
    private DatabaseRootPanel dbRootPanel = new DatabaseRootPanel();
    private TablePanel tablePanel = new TablePanel();
    private ViewPanel viewPanel = new ViewPanel();
    private UserPanel userPanel = new UserPanel();
    private GroupPanel groupPanel = new GroupPanel();
    private DatabasePanel databasePanel = new DatabasePanel();
    private SequencePanel sequencePanel = new SequencePanel();
    private TreeElementsPanel treePanel = new TreeElementsPanel();
    
    /** Creates a new instance of PrincipalFrameComponent */
    public PrincipalFrameComponent(PrincipalFrame _frame) {
        frame = _frame;
        setPreferredSize(new Dimension(600, 400));
        setDividerLocation(200);
        setOneTouchExpandable(true);
        
        tree_control = new TreeControl(frame);
        setLeftComponent(new JScrollPane(tree_control));
        setRightComponent(default_panel);
    }
    
    public void updateSelectedObject(TreeInfo _obj){
        if ((last_selected == null) || (last_selected != _obj)){
            last_selected = _obj;
            if (_obj.getClass() == RootElement.class) {
                dbRootPanel.setDatabase(((RootElement) _obj).getDatabase());
                setRightComponent(dbRootPanel);
            } else if (_obj.getClass() == Element.class) {
                DBObject tmp_element = ((Element) _obj).getSource();
                if(tmp_element.getClass() == Table.class){
                    tablePanel.setTable((Table) tmp_element);
                    setRightComponent(tablePanel);
                } else if(tmp_element.getClass() == View.class){
                    viewPanel.setView((View) tmp_element);
                    setRightComponent(viewPanel);
                } else if(tmp_element.getClass() == Database.class){
                    databasePanel.setDatabase((Database) tmp_element);
                    setRightComponent(databasePanel);
                } else if(tmp_element.getClass() == User.class){
                    userPanel.setUser((User) tmp_element);
                    setRightComponent(userPanel);
                } else if(tmp_element.getClass() == Group.class){
                    groupPanel.setGroup((Group) tmp_element);
                    setRightComponent(groupPanel);
                } else if(tmp_element.getClass() == Sequence.class){
                    sequencePanel.setSequence((Sequence) tmp_element);
                    setRightComponent(sequencePanel);
                }
            } else if (TreeInfo.class.isInstance(_obj)) {
                    treePanel.setTreeElement(_obj);
                    setRightComponent(treePanel);
            } else {
                setRightComponent(default_panel);
            }
        }
    }
    
    public void refreshValidation(){
        if(frame != null){
            boolean valid = frame.getDatabase().validate();
            if(!valid){
                setRightComponent(default_panel);
            }
        }
    }
    
    public void refreshTree(){
        frame.setDatabase(Database.getMainConnection());
        tree_control.refreshTree();
    }
    
    public void setDataComponent(Component _component){
        setRightComponent(_component);
    }
}
