/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.largeobject;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.postgresql.largeobject.LargeObject;

public class BlobInputStream
extends InputStream {
    private LargeObject lo;
    private byte[] buffer;
    private int bpos;
    private int bsize;
    private int mpos = 0;

    public BlobInputStream(LargeObject largeObject) {
        this(largeObject, 1024);
    }

    public BlobInputStream(LargeObject largeObject, int n) {
        this.lo = largeObject;
        this.buffer = null;
        this.bpos = 0;
        this.bsize = n;
    }

    public void close() throws IOException {
        try {
            this.lo.close();
            this.lo = null;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    public synchronized void mark(int n) {
        try {
            this.mpos = this.lo.tell();
        }
        catch (SQLException sQLException) {}
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        try {
            if (this.buffer == null || this.bpos >= this.buffer.length) {
                this.buffer = this.lo.read(this.bsize);
                this.bpos = 0;
            }
            if (this.bpos >= this.buffer.length) {
                return -1;
            }
            int n = this.buffer[this.bpos] & 0x7F;
            if ((this.buffer[this.bpos] & 0x80) == 128) {
                n |= 0x80;
            }
            ++this.bpos;
            return n;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    public synchronized void reset() throws IOException {
        try {
            this.lo.seek(this.mpos);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }
}

