/*
 * ColumnPanel.java
 *
 * Created on 1 de agosto de 2002, 16:34
 */

package components.table;
import components.*;
import javax.swing.*;
import java.awt.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class ColumnPanel extends JPanel {
    private Table table = null;
    private SQLTable data_table = new SQLTable();
    private ColumnPanelListener listener = null;
    
    /** Creates a new instance of ColumnPanel */
    public ColumnPanel() {
        data_table = new SQLTable();
        listener = new ColumnPanelListener(this);
        initPanel();
    }
    
    private void initPanel(){
        setLayout(new BorderLayout());
        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));

        
        SQLTableModel sql_tm = new SQLTableModel(data_table);
        data_table.setModel(sql_tm);
        
        add(new ColumnPanelToolbar(this), BorderLayout.NORTH);
        add(new JScrollPane(data_table), BorderLayout.CENTER);
    }
    public void refresh(){
        ((SQLTableModel) data_table.getModel()).setDataSource(table.getColumnsTable());
        repaint();
    }
    public void refresh(Table table_object){
        table = table_object;
        refresh();
    }
    
    public Table getTable(){
        return table;
    }
    
    public ColumnPanelListener getListener(){
        return listener;
    }
    
    public void newColumn(){
    }
    public void editColumn(){
    }
    public void deleteColumn(){
    }
}

