-- $Id: sample_data.sql,v 1.12 2003/12/20 04:19:54 mig Exp $
INSERT INTO config (name, descr, value) VALUES('tmpl_path',
	'Path of the html templates',
	'/home/mig/dev/comas/consol/templates');

INSERT INTO config (name, descr, value) VALUES('proposals_new_max_date',
	'The last date for sending a proposal, the format is YYYY-MM-DD HH:MM (in
	24 hours style)',
	'2003-11-1 12:00');

INSERT INTO config (name, descr, value) VALUES('proposals_accepted_id',
	'The id of the accepted proposals',
	'10');

INSERT INTO config (name, descr, value) VALUES('priv_person_types',
	'The privileged person types (an administrator should set this in a 
	person), separated by ,',
	'2,3,4');

INSERT INTO config (name, descr, value) VALUES('max_proposals_x_person',
	'The limit of proposals per person',
	'3');

INSERT INTO config (name, descr, value) VALUES('max_authors_x_proposal',
	'The limit of authors per proposal',
	'2');

INSERT INTO prop_status (id, descr) VALUES (1, 'New');
INSERT INTO prop_status (id, descr) VALUES (2, 'Details requested');
INSERT INTO prop_status (id, descr) VALUES (5, 'Rejected');
INSERT INTO prop_status (id, descr) VALUES (10, 'Accepted');

INSERT INTO prop_type (id, descr, duration) VALUES (1, 'Presentation', '01:00');
INSERT INTO prop_type (id, descr, duration) VALUES (2, 'Tutorial', '02:00');
INSERT INTO prop_type (id, descr, duration) VALUES (3, 'Workshop', '04:00');
INSERT INTO prop_type (id, descr, duration) VALUES (4, 'Full-day session', 
    '08:00');

INSERT INTO track (id, descr) VALUES (1, 'Development');
INSERT INTO track (id, descr) VALUES (2, 'Security');
INSERT INTO track (id, descr) VALUES (3, 'End-user');
INSERT INTO track (id, descr) VALUES (4, 'Philosophy');

INSERT INTO room (id, descr, max_people) VALUES (1, 'Main auditorium', 0);
INSERT INTO room (id, descr, max_people) VALUES (2, 'Room A', 0);
INSERT INTO room (id, descr, max_people) VALUES (3, 'Room B', 0);

INSERT INTO studies (id, descr) VALUES (1, 'None');
INSERT INTO studies (id, descr) VALUES (2, 'Technical');
INSERT INTO studies (id, descr) VALUES (3, 'Bachelor');
INSERT INTO studies (id, descr) VALUES (4, 'Master');
INSERT INTO studies (id, descr) VALUES (5, 'Ph. D.');
INSERT INTO studies (id, descr) VALUES (6, 'Other');

INSERT INTO person_type (id, descr) VALUES (1, 'Attendee');
INSERT INTO person_type (id, descr) VALUES (2, 'Speaker');
INSERT INTO person_type (id, descr) VALUES (3, 'Organizer');
INSERT INTO person_type (id, descr) VALUES (4, 'Volunteer');

INSERT INTO state (id, descr) VALUES (1, 'Aguascalientes');
INSERT INTO state (id, descr) VALUES (2, 'Baja California');
INSERT INTO state (id, descr) VALUES (3, 'Baja California Sur');
INSERT INTO state (id, descr) VALUES (4, 'Campeche');
INSERT INTO state (id, descr) VALUES (5, 'Chiapas');
INSERT INTO state (id, descr) VALUES (6, 'Chihuahua');
INSERT INTO state (id, descr) VALUES (7, 'Coahuila');
INSERT INTO state (id, descr) VALUES (8, 'Colima');
INSERT INTO state (id, descr) VALUES (9, 'Distrito Federal');
INSERT INTO state (id, descr) VALUES (10, 'Durango');
INSERT INTO state (id, descr) VALUES (11, 'Guanajuato');
INSERT INTO state (id, descr) VALUES (12, 'Guerrero');
INSERT INTO state (id, descr) VALUES (13, 'Hidalgo');
INSERT INTO state (id, descr) VALUES (14, 'Jalisco');
INSERT INTO state (id, descr) VALUES (15, 'Mxico');
INSERT INTO state (id, descr) VALUES (16, 'Michoacn');
INSERT INTO state (id, descr) VALUES (17, 'Morelos');
INSERT INTO state (id, descr) VALUES (18, 'Nayarit');
INSERT INTO state (id, descr) VALUES (19, 'Nuevo Len');
INSERT INTO state (id, descr) VALUES (20, 'Oaxaca');
INSERT INTO state (id, descr) VALUES (21, 'Puebla');
INSERT INTO state (id, descr) VALUES (22, 'Quertaro');
INSERT INTO state (id, descr) VALUES (23, 'Quintana Roo');
INSERT INTO state (id, descr) VALUES (24, 'San Luis Potos');
INSERT INTO state (id, descr) VALUES (25, 'Sinaloa');
INSERT INTO state (id, descr) VALUES (26, 'Sonora');
INSERT INTO state (id, descr) VALUES (27, 'Tabasco');
INSERT INTO state (id, descr) VALUES (28, 'Tamaulipas');
INSERT INTO state (id, descr) VALUES (29, 'Tlaxcala');
INSERT INTO state (id, descr) VALUES (30, 'Veracruz');
INSERT INTO state (id, descr) VALUES (31, 'Yucatn');
INSERT INTO state (id, descr) VALUES (32, 'Zacatecas');

INSERT INTO country (id, descr) VALUES (1, 'Mxico');
INSERT INTO country (id, descr) VALUES (2, 'United States/Canada');
INSERT INTO country (id, descr) VALUES (3, 'Central America/Caribbean');
INSERT INTO country (id, descr) VALUES (4, 'South America');
INSERT INTO country (id, descr) VALUES (5, 'Europe');
INSERT INTO country (id, descr) VALUES (6, 'Asia');
INSERT INTO country (id, descr) VALUES (7, 'Africa');
INSERT INTO country (id, descr) VALUES (8, 'Oceania');

INSERT INTO pers_status (id, descr) VALUES (1, 'Normal');
INSERT INTO pers_status (id, descr) VALUES (2, 'Invited');
INSERT INTO pers_status (id, descr) VALUES (3, 'Confirmed');
INSERT INTO pers_status (id, descr) VALUES (4, 'Cancelled');

INSERT INTO task (id, descr) VALUES (1, 'Academic comittee');
INSERT INTO task (id, descr) VALUES (2, 'Administrative comittee');

INSERT INTO person (login, firstname, famname, nickname, passwd, org, dept, 
    studies_id, email, person_type_id, postal_addr, zip, city, state_id,
    country_id, phone, fax, birth, resume, reg_time, pers_status_id) 
VALUES ('gwolf', 'Gunnar', 'Wolf', 'gwolf', 'mipass', 'UPN', 'CabrasLocas',
    3, 'gwolf@gwolf.cx', 1, 'Av. Copilco 233', '04360', 'Mxico', 9,
    1, '55-5554-9450', '55-5554-9450', '1976-04-27', 'Works writing Comas', 
    '2003-06-28 10:07:00.126442', 1);
INSERT INTO person (login, firstname, famname, nickname, passwd, org, dept, 
    studies_id, email, person_type_id, city, state_id,
    country_id, resume, reg_time, pers_status_id) 
VALUES ('mig', 'Manuel', 'Rbade', 'MiG', 'tupass', 'UNAM', 'Ingenieria',
    2, 'mig@mig-29.net', 1, 'Mxico', 9,
    1, 'Is writing a conference management system', 
    '2003-07-01 16:17:06.351534', 1);
INSERT INTO person (login, firstname, famname, nickname, passwd, org, dept, 
    studies_id, email, person_type_id, city, state_id,
    country_id, resume, reg_time, pers_status_id) 
VALUES ('pepito', 'Pepe', 'Sanchez', 'Pepito', 'supass', 'IPN', 'Medicina',
    5, 'pepito@hotmail.com', 1, 'Mxico', 9,
    1, 'Is a nice dummy register in our database', 
    now(), 1);
INSERT INTO person (login, firstname, famname, nickname, passwd, org, dept, 
    studies_id, email, person_type_id, city, state_id,
    country_id, resume, reg_time, pers_status_id) 
VALUES ('juanito', 'Juan', 'Perez', 'Juanito', 'supass', 'UAM', 'Diseo',
    4, 'juanito@yahoo.com', 1, 'Mxico', 9,
    1, 'Another happy dummy register', 
    now(), 1);

INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (1, '10:00:00', '2004-02-10', 1);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (2, '11:00:00', '2004-02-10', 1);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (3, '12:00:00', '2004-02-10', 1);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (4, '13:00:00', '2004-02-10', 1);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (5, '14:00:00', '2004-02-10', 1);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (6, '15:00:00', '2004-02-10', 1);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (7, '16:00:00', '2004-02-10', 1);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (8, '17:00:00', '2004-02-10', 1);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (9, '18:00:00', '2004-02-10', 1);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (10, '19:00:00', '2004-02-10', 1);

INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (11, '10:00:00', '2004-02-10', 2);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (12, '11:00:00', '2004-02-10', 2);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (13, '12:00:00', '2004-02-10', 2);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (14, '13:00:00', '2004-02-10', 2);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (15, '14:00:00', '2004-02-10', 2);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (16, '15:00:00', '2004-02-10', 2);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (17, '16:00:00', '2004-02-10', 2);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (18, '17:00:00', '2004-02-10', 2);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (19, '18:00:00', '2004-02-10', 2);
INSERT INTO timeslot (id, start_hr, day, room_id) VALUES (20, '19:00:00', '2004-02-10', 2);

INSERT INTO timeslot_prop_type (type, timeslot) VALUES (1, 1);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (1, 2);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (1, 3);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (1, 4);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (1, 5);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (1, 6);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (1, 7);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (1, 8);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (1, 9);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (1, 10);

INSERT INTO timeslot_prop_type (type, timeslot) VALUES (2, 1);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (2, 3);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (2, 5);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (2, 7);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (2, 9);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (3, 1);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (3, 5);
INSERT INTO timeslot_prop_type (type, timeslot) VALUES (4, 1);

INSERT INTO proposal (title, abstract, track_id, prop_status_id,
	prop_type_id)
VALUES ('First proposed talk', 
	'This is a talk that will talk about proposals', 1, 1, 
  	1);
INSERT INTO proposal (title, abstract, track_id, prop_status_id,
    prop_type_id)
VALUES ('A bad proposal', 
'This one should be rejected. It is boring.', 3, 5, 
    4);
INSERT INTO proposal (title, abstract, track_id, prop_status_id,
    prop_type_id)
VALUES ('How to submit successful talks', 
'A short tutorial on how to submit talks to Comas', 3, 1, 
    2);
INSERT INTO proposal (title, abstract, track_id, prop_status_id,
    prop_type_id)
VALUES ('How to manage talks', 
'A short tutorial on how to manage talks in Comas', 3, 1, 
    2);

INSERT INTO authors (person_id, proposal_id, mention_order) VALUES (1, 1, 1);
INSERT INTO authors (person_id, proposal_id, mention_order) VALUES (1, 2, 2);
INSERT INTO authors (person_id, proposal_id, mention_order) VALUES (2, 1, 2);
INSERT INTO authors (person_id, proposal_id, mention_order) VALUES (2, 3, 1);
INSERT INTO authors (person_id, proposal_id, mention_order) VALUES (3, 1, 3);
INSERT INTO authors (person_id, proposal_id, mention_order) VALUES (3, 4, 1);

UPDATE proposal set prop_status_id = 10, timeslot_id = 1 where id = 1;
UPDATE proposal set prop_status_id = 10 where id = 3;
UPDATE proposal set prop_status_id = 10 where id = 4;
UPDATE proposal set prop_status_id = 10 where id = 4;
UPDATE proposal set prop_status_id = 10 where id = 4;
UPDATE proposal set prop_status_id = 10 where id = 4;

-- $Log: sample_data.sql,v $
-- Revision 1.12  2003/12/20 04:19:54  mig
-- - Agrego tags Id y Log que expanda el CVS
--
