/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *   Ron Pruitt <wa84it@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var curDir = "";
var processedDir = "";
var canAccept = true;
const COL_ID = [ "flag", "title", "read", "date", "author", "source", "blog", "prob" ];
const DIR = [ "ascending", "descending" ];

function init()
{
	const NF_SB = document.getElementById("newsfox-string-bundle");
	checkLocalPng("pOhelp","help.png","src");
	checkLocalPng("pOfolderClosed","folderClosed.png","image");

	var args = window.arguments[0];
	var gOpt = args.gOpt;

	var style = gOpt.globalStyle;
	var list = document.getElementById("style");
	list.selectedIndex = style-1;

	document.getElementById("cbCheckOnStartup").checked = gOpt.checkOnStartup;
	document.getElementById("cbNotifyUponNew").checked = gOpt.notifyUponNew;
	document.getElementById("cbConfirmDelete").checked = gOpt.confirmDelete;
	var keyIndex = args.keyIndex;
	document.getElementById("shortcut").selectedIndex = keyIndex;
	if (keyIndex != 3) document.getElementById("custshortcut").hidden = true;
	curDir = args.nfDir;
	document.getElementById("nfdir").value = curDir;
	var dat = new Date(NEWSFOX_DATE);
	document.getElementById("date0").label = displayDate(dat,0);
	document.getElementById("date1").label = displayDate(dat,1);
	document.getElementById("date2").label = displayDate(dat,2);
	document.getElementById("dateStyle").selectedIndex = -1;
	document.getElementById("dateStyle").selectedIndex = gOpt.dateStyle;
	document.getElementById("pOnone").checked = !gOpt.dateNoneStrict;
	document.getElementById("pOnone").label = NF_SB.getString('NO_DATE');
	document.getElementById("pOinvalid").checked = !gOpt.dateInvalidStrict;
	document.getElementById("pOinvalid").label = NF_SB.getString('INVALID_DATE');
	document.getElementById("pOfuture").checked = !gOpt.dateFutureStrict;
	document.getElementById("pOfuture").label = NF_SB.getString('FUTURE_DATE');
	document.getElementById("pOtooltip").checked = gOpt.artTooltip;
	document.getElementById("pOchangedUnread").checked = gOpt.changedUnread;
	document.getElementById("pOcopyClip").checked = gOpt.copyToClip;
	document.getElementById("pOselectAddedFeed").checked = gOpt.selectAddedFeed;
	document.getElementById("pOtimeout").value = gOpt.refreshTimeout/1000;
	document.getElementById("pOhoriz").checked = gOpt.horiz;
	document.getElementById("pOfavicons").checked = gOpt.favicons;
	document.getElementById("pOspam").checked = gOpt.spam;
	var pOsync = document.getElementById("pOsync");
	pOsync.checked = gOpt.bookmarkSync;
	setUserAgent();
	if (gKMeleon) pOsync.hidden = true;
	for (var i=1; i<=gOpt.sorts.length; i++)
	{
		switch (gOpt.sorts[i-1].colId)
		{
			case "flag":
				document.getElementById("sort"+i).selectedIndex=1;
				break;
			case "title":
				document.getElementById("sort"+i).selectedIndex=2;
				break;
			case "read":
				document.getElementById("sort"+i).selectedIndex=3;
				break;
			case "date":
				document.getElementById("sort"+i).selectedIndex=4;
				break;
			case "author":
				document.getElementById("sort"+i).selectedIndex=5;
				break;
			case "source":
				document.getElementById("sort"+i).selectedIndex=6;
				break;
			case "blog":
				document.getElementById("sort"+i).selectedIndex=7;
				break;
			case "prob":
				document.getElementById("sort"+i).selectedIndex=8;
		}
		switch (gOpt.sorts[i-1].dir)
		{
			case "ascending":
				document.getElementById("dir"+i).selectedIndex = 0;
				break;
			case "descending":
				document.getElementById("dir"+i).selectedIndex = 1;
		}
	}
	for (var i=gOpt.sorts.length+1; i<=4; i++)
	{
		document.getElementById("sort"+i).selectedIndex=0;
		document.getElementById("dir"+i).disabled = true;
	}
}

function doAccept()
{
	if (!canAccept)
	{
		canAccept = true;
		return false;
	}

	const NF_SB = document.getElementById("newsfox-string-bundle");
	var args = window.arguments[0];
	var gOpt = args.gOpt;

	var elem = document.getElementById("style");
	gOpt.globalStyle = parseInt(elem.value);

	gOpt.checkOnStartup = document.getElementById("cbCheckOnStartup").checked;

	gOpt.notifyUponNew = document.getElementById("cbNotifyUponNew").checked;
	gOpt.confirmDelete = document.getElementById("cbConfirmDelete").checked;
	args.newKeyIndex = document.getElementById("shortcut").selectedIndex;
	gOpt.dateStyle = document.getElementById("dateStyle").selectedIndex;
	gOpt.dateNoneStrict = !document.getElementById("pOnone").checked;
	gOpt.dateInvalidStrict = !document.getElementById("pOinvalid").checked;
	gOpt.dateFutureStrict = !document.getElementById("pOfuture").checked;
	gOpt.artTooltip = document.getElementById("pOtooltip").checked;
	gOpt.changedUnread = document.getElementById("pOchangedUnread").checked;
	gOpt.copyToClip = document.getElementById("pOcopyClip").checked;
	gOpt.selectAddedFeed = document.getElementById("pOselectAddedFeed").checked;
	gOpt.refreshTimeout = parseInt(1000 * document.getElementById("pOtimeout").value);
	gOpt.horiz = document.getElementById("pOhoriz").checked;
	gOpt.favicons = document.getElementById("pOfavicons").checked;
	gOpt.spam = document.getElementById("pOspam").checked;
	gOpt.bookmarkSync = document.getElementById("pOsync").checked;

	gOpt.sorts = new Array();
	for (var i=1; i<=4; i++)
	{
		var colIdIndex = document.getElementById("sort"+i).selectedIndex;
		if (colIdIndex == 0) break;
		var dirIndex = document.getElementById("dir"+i).selectedIndex;
		var sPair = new sortPair();
		sPair.colId = COL_ID[colIdIndex-1];
		sPair.dir = DIR[dirIndex];
		gOpt.sorts.push(sPair);
		setPref("sorts.column"+(i-1), "str", sPair.colId);
		setPref("sorts.direction"+(i-1), "str", sPair.dir);
	}
	if (i == 1)
	{
		setPref("sorts.column0", "str", "none");
		i++;
	}
	var prefs = Components.classes["@mozilla.org/preferences-service;1"]
			.getService(Components.interfaces.nsIPrefService)
			.getBranch("newsfox.");
	for (var j=i; j<=4; j++)
	{
		if (getPref("sorts.column"+(j-1), "str", null))
			prefs.clearUserPref("sorts.column"+(j-1));
		if (getPref("sorts.direction"+(j-1), "str", null))
			prefs.clearUserPref("sorts.direction"+(j-1));
	}

	var nfDir = document.getElementById("nfdir").value;
	args.nfDir = nfDir;
	var mvContents = document.getElementById("mvNfDir").selectedIndex;
	args.mvContents = mvContents;
	if (mvContents < 2 && curDir != nfDir)
	{
		var nsIPH = Components.classes["@mozilla.org/network/protocol;1?name=file"].createInstance(Components.interfaces.nsIFileProtocolHandler);
		var nfDirFile = nsIPH.getFileFromURLSpec(nfDir);
  	var dirNotEmpty = NF_SB.getString('dirNotEmpty');
		if (nfDirFile.directoryEntries.hasMoreElements())  // not empty
			if (!window.confirm(dirNotEmpty))
			{
				document.getElementById("nfdir").value = curDir;
				checkDir();
				return false;
			}
	}
	args.ok = true;
	return true;
}

function chooseDir()
{
	var nsIPH = Components.classes["@mozilla.org/network/protocol;1?name=file"].createInstance(Components.interfaces.nsIFileProtocolHandler);
	var url = document.getElementById("nfdir").value;
	var file = nsIPH.getFileFromURLSpec(url);
	var picker = nfDirPicked(file);
	if (picker)
	{
		var nfdir = nsIPH.getURLSpecFromFile(picker.file);
		processDir(nfdir);
	}
}

function checkDir()
{
	canAccept = true;
	var nfdir = document.getElementById("nfdir").value;
	if (nfdir == "") nfdir = curDir;
	if (nfdir.charAt(nfdir.length-1) != "/") nfdir += "/";
	document.getElementById("nfdir").value = nfdir;
	if (nfdir == processedDir) return true;
	var nsIPH = Components.classes["@mozilla.org/network/protocol;1?name=file"].createInstance(Components.interfaces.nsIFileProtocolHandler);
	const NF_SB = document.getElementById("newsfox-string-bundle");
	try 
	{ var nffile = nsIPH.getFileFromURLSpec(nfdir); }
	catch(e)
	{
		alert(NF_SB.getString('badDir'));
		document.getElementById("nfdir").value = curDir;
		canAccept = false;
		return false;
	}
	if (!nffile.exists())
	{
		if (window.confirm(NF_SB.getString('createDir')))
			nffile.create(0x01, 0750);
		else
			nfdir = curDir;
	}
	processDir(nfdir);
	return false;
}

function processDir(nfdir)
{
	canAccept = false;
	document.getElementById("nfdir").value = nfdir;
	processedDir = nfdir;
	var mvContents = document.getElementById("mvNfDirHBox");
	if (curDir == nfdir)
		mvContents.hidden = true;
	else
	{
		document.getElementById("mvNFDirCopy").hidden = false;
		document.getElementById("mvNFDirMove").hidden = false;
		document.getElementById("mvChild").hidden = true;
		document.getElementById("mvParent").hidden = true;
		mvContents.hidden = false;
		if (nfdir.indexOf(curDir) > -1 || curDir.indexOf(nfdir) > -1)
		{
			document.getElementById("mvNFDirCopy").hidden = true;
			document.getElementById("mvNFDirMove").hidden = true;
			document.getElementById("mvNfDir").selectedIndex = 2;
			if (nfdir.indexOf(curDir) > -1)
				document.getElementById("mvChild").hidden = false;
			else
				document.getElementById("mvParent").hidden = false;
		}
	}
	window.sizeToContent();
}

function sortChg()
{
	for (var i=1; i<=4; i++)
	{
		if (document.getElementById("sort"+i).selectedIndex == 0)
		{
			document.getElementById("dir"+i).disabled = true;
			for (var j=i+1; j<=4; j++)
				document.getElementById("sort"+j).selectedIndex = 0;
		}
		else
			document.getElementById("dir"+i).removeAttribute("disabled");
	}
}
