/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *   Ron Pruitt <wa84it@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////////////////////////
// Global
////////////////////////////////////////////////////////////////

var gOptions = new AppOptions();

var noObserve = false;
const MAX_SCRIPT = 20;

var nFprefObserver = 
{
	observe: function(subject, topic, data)
	{
		if (noObserve) return;
		gOptions.load();
		if (gOptions.addUrl != "") addFeedUrl();
	} 
}

////////////////////////////////////////////////////////////////
// Model
////////////////////////////////////////////////////////////////

function AppOptions()
{
// properties assigned in this.load()

	this.startup = function()
	{
		var maxScript = getPref("dom.max_script_run_time","int",10,true);
		if (maxScript < MAX_SCRIPT)
			setPref("dom.max_script_run_time","int",MAX_SCRIPT,true);
		this.renamePrefs();
		this.moveAutoCheckToFeed();
		// need to set the directory preference, so the observer doesn't catch 
		// the setting later and process the addurl before models loaded
		var file = getProfileDir();
		this.load();
		this.save(true);
		this.addObserver();
		this.loadImages();
	}

	this.addObserver = function()
	{
		var nsIPrefBranch2 = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2);
		nsIPrefBranch2.addObserver("newsfox.", nFprefObserver, false);
	}

	this.rmObserver = function()
	{
		var nsIPrefBranch2 = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2);
		nsIPrefBranch2.removeObserver("newsfox.", nFprefObserver);
	}

  this.load = function()
  {
  // 1 Text
  // 2 Web page
    this.globalStyle = getPref("global.style", "int", 1);
    this.checkOnStartup = getPref("global.checkOnStartup", "bool", false);
		this.notifyUponNew = getPref("global.notifyUponNew", "bool", true);
		this.confirmDelete = getPref("global.confirmDelete", "bool", true);
	// 0 ISO date, no seconds
	// 1 system short date
	// 2 system long date
		this.dateStyle = getPref("global.dateStyle", "int", 0);
		this.addUrl = getPref("internal.addUrl", "str", NEWSFOX_RSS);
		this.favicons = getPref("advanced.favicons", "bool", getPref("browser.chrome.favicons","bool",true,true));
		this.guessHomepage = getPref("advanced.guessHomepage", "bool", true);
		this.refreshTimeout = 1000 * getPref("advanced.refreshTimeoutInSeconds", "int", 60);
		this.horiz = getPref("advanced.horizontalPanes", "bool", false);
		this.copyToClip = getPref("advanced.copyArtBodyToClipboard","bool", false);
		this.selectAddedFeed = getPref("advanced.selectAddedFeed", "bool", true);
		this.changedUnread = getPref("advanced.markChangedArtAsUnread", "bool", false);
		this.artTooltip = getPref("advanced.articleTooltip", "bool", false);
		var intTime = getPref("advanced.autoRefreshTime", "int", MINAUTOTIME);
		if (!(intTime >= MINAUTOTIME)) intTime = MINAUTOTIME;
		this.autoRefreshTime = 1000 * 60 * intTime;
		this.bookmarkSync = getPref("advanced.bookmarkSync", "bool", false);
	// 0 alphabetical
	// 1 cats with unread first alphabetically, then cats with no unread
	// 2 descending by #unread
		this.catSort = getPref("advanced.catSort", "int", 1);
		this.spam = getPref("advanced.interestFilter", "bool", true);
		this.daysKeep = getPref("advanced.daysToKeepGlobal", "int", -1);

		this.dateNoneStrict = getPref("date.noneStrict", "bool", false);
		this.dateInvalidStrict = getPref("date.invalidStrict", "bool", false);
		this.dateFutureStrict = getPref("date.futureStrict", "bool", false);

		this.srchUnread = getPref("override.showSearchUnread", "bool", true);

		this.dragCopy = getPref("z.dragFeedOutOfGroupIsCopy", "bool", true);
		this.markRead = getPref("z.selectMarksArticleAsRead", "bool", true);
		this.openInViewPane = getPref("z.openInViewPane", "bool", false);
		this.slowDelete = getPref("z.slowDelete", "bool", false);

		this.sorts = new Array();
		var i = 0;
		while (getPref("sorts.column"+i, "str", null))
		{
			var sPair = new sortPair();
			var s = getPref("sorts.column"+i, "str", null);
			switch (s.substring(0,1).toLowerCase())
			{
				case "f":
					sPair.colId = "flag";
				case "t":
					if (!sPair.colId) sPair.colId = "title";
				case "r":
					if (!sPair.colId) sPair.colId = "read";
				case "d":
					if (!sPair.colId) sPair.colId = "date";
				case "a":
					if (!sPair.colId) sPair.colId = "author";
				case "s":
					if (!sPair.colId) sPair.colId = "source";
				case "b":
					if (!sPair.colId) sPair.colId = "blog";
				case "p":
					if (!sPair.colId) sPair.colId = "prob";
					s = getPref("sorts.direction"+i, "str", "d");
					switch (s.substring(0,1).toLowerCase())
					{
						case "a":
							sPair.dir = "ascending";
						case "d":
							if (!sPair.dir) sPair.dir = "descending";
							this.sorts.push(sPair);
						default:
					}
				default: i++
			}
		}
		if (i == 0)
		{
			var sPair = new sortPair();
			sPair.colId = "date";
			sPair.dir = "descending";
			this.sorts.push(sPair);
			setPref("sorts.column0", "str", sPair.colId);
			setPref("sorts.direction0", "str", sPair.dir);
		}
  }

  this.save = function(savenonUI)
  {
		noObserve = true;  // can't have observer while saving many options
    setPref("global.style", "int", this.globalStyle);
    setPref("global.checkOnStartup", "bool", this.checkOnStartup);
		setPref("global.notifyUponNew", "bool", this.notifyUponNew);
		setPref("global.confirmDelete", "bool", this.confirmDelete);
		setPref("global.dateStyle", "int", this.dateStyle);
		setPref("internal.addUrl", "str", this.addUrl);
		setPref("date.noneStrict", "bool", this.dateNoneStrict);
		setPref("date.invalidStrict", "bool", this.dateInvalidStrict);
		setPref("date.futureStrict", "bool", this.dateFutureStrict);
		setPref("advanced.refreshTimeoutInSeconds", "int", this.refreshTimeout/1000);
		setPref("advanced.copyArtBodyToClipboard", "bool", this.copyToClip);
		setPref("advanced.selectAddedFeed", "bool", this.selectAddedFeed);
		setPref("advanced.markChangedArtAsUnread", "bool", this.changedUnread);
		setPref("advanced.articleTooltip", "bool", this.artTooltip);
		if (this.artTooltip)
			setArtTooltip();
		else
			rmArtTooltip();
		setPref("advanced.favicons", "bool", this.favicons);
		setPref("advanced.horizontalPanes", "bool", this.horiz);
		setPref("advanced.bookmarkSync", "bool", this.bookmarkSync);
		setPref("advanced.interestFilter", "bool", this.spam);
		if (savenonUI)
		{
			setPref("advanced.guessHomepage", "bool", this.guessHomepage);
			setPref("advanced.autoRefreshTime", "int", this.autoRefreshTime/60000);
			setPref("override.showSearchUnread", "bool", this.srchUnread);
			setPref("advanced.catSort", "int", this.catSort);
		 	setPref("advanced.daysToKeepGlobal", "int", this.daysKeep);
		}
		noObserve = false;
  }

	this.renamePrefs = function()
	{
		var prefs = Components.classes["@mozilla.org/preferences-service;1"]
				.getService(Components.interfaces.nsIPrefService)
				.getBranch("newsfox.");
		var openNewPref = getPref("advanced.buttonOpensNewTab", "bool", null);
		if (openNewPref != null)
		{
			if (openNewPref) setPref("z.buttonOpensNewTab", "bool", true);
			prefs.clearUserPref("advanced.buttonOpensNewTab");
		}
		var done = getPref("internal.rename", "bool", false);
		if (!done)
		{
			setPref("internal.addUrl", "str", 
				getPref("global.addUrl", "str", NEWSFOX_RSS));
			if (getPref("global.addUrl","str",null))
				prefs.clearUserPref("global.addUrl");
			setPref("advanced.favicons", "bool", 
				getPref("global.favicons", "bool", 
					getPref("browser.chrome.favicons","bool",true,true)));
			if (getPref("global.favicons","bool",null))
				prefs.clearUserPref("global.favicons");
			setPref("advanced.guessHomepage", "bool", 
				getPref("global.guessHomepage", "bool", true));
			if (getPref("global.guessHomepage","bool",null))
				prefs.clearUserPref("global.guessHomepage");
			setPref("advanced.refreshTimeoutInSeconds", "int", 
				getPref("global.refreshTimeoutInSeconds", "int", 60));
			if (getPref("global.refreshTimeoutInSeconds","int",null))
				prefs.clearUserPref("global.refreshTimeoutInSeconds");
			setPref("advanced.horizontalPanes", "bool", 
				getPref("global.horizontalPanes", "bool", false));
			if (getPref("global.horizontalPanes","bool",null))
				prefs.clearUserPref("global.horizontalPanes");
			if (!gKMeleon)
			{
				setPref("internal.doneButton", "bool", 
					getPref("global.doneButton", "bool", false));
				if (getPref("global.doneButton","bool",null))
					prefs.clearUserPref("global.doneButton");
				setPref("internal.doneAutoSubscribe", "bool", 
					getPref("global.doneAutoSubscribe", "bool", false));
				if (getPref("global.doneAutoSubscribe","bool",null))
					prefs.clearUserPref("global.doneAutoSubscribe");
			}
			setPref("internal.rename", "bool", true);
		}
	}

	this.loadImages = function()
	{
		checkLocalPng("tBcheck","check.png");
		checkLocalPng("tBcancel","cancel.png");
		checkLocalPng("tBaddFolder","addFolder.png");
		checkLocalPng("tBdelFolder","delFolder.png");
		checkLocalPng("tBadd","add.png");
		checkLocalPng("tBdel","del.png");
		checkLocalPng("tBlivemark","livemark.png");
		checkLocalPng("tBoptions","options.png");
		checkLocalPng("tBhelp","help.png");
		checkLocalPng("fBhome","home.png");
		checkLocalPng("fBcheck","check.png");
		checkLocalPng("fBtag","tag.png");
		checkLocalPng("fBmarkAllAsRead","markAllAsRead.png");
		checkLocalPng("fBmarkAllAsUnread","markAllAsUnread.png");
		checkLocalPng("fBdelete","delete.png");
		checkLocalPng("fBoptions","options.png");
	}

	this.moveAutoCheckToFeed = function()
	{
		var doAuto = getPref("global.autoRefresh", "bool", false);
		this.moveAuto = 0;
		if (doAuto) this.moveAuto = getPref("global.autoRefreshInterval", "int", 30)
		var prefs = Components.classes["@mozilla.org/preferences-service;1"]
				.getService(Components.interfaces.nsIPrefService)
				.getBranch("newsfox.");
		if (getPref("global.autoRefresh","bool",null))
			prefs.clearUserPref("global.autoRefresh");
		if (getPref("global.autoRefreshInterval", "int", null))
			prefs.clearUserPref("global.autoRefreshInterval");
	}
}

function moveAutoCheck()
{
	var aRI = gOptions.moveAuto;
	for (var i=0; i<gFmodel.size(); i++)
	{
		var feed = gFmodel.get(i);
		if (feed.autoCheck) feed.autoRefreshInterval = aRI;
	}
}
