/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Ron Pruitt <wa84it@gmail.com>.
 * Portions created by the Initial Developer are Copyright (C) 2006-2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const NF_ADDURI = "chrome://newsfox/content/addurl.xul?%s";
const AUTOSIZE = 30;
const MY_EXTENSION_UUID = "{899DF1F8-2F43-4394-8315-37F6744E6319}";
const NF_MENUBAR = "toolbar-menubar";
const NF_NAVBAR = "nav-bar";
const NF_NAVBAR_NEW = "navigation-toolbar";

function initoverlay(event)
{
	setCSS();
	setUserAgent();
	if (gKMeleon && !gEMusic)
	{
		location.href = "chrome://newsfox/content/newsfox.xul";
		return;
	}
	window.removeEventListener('load', initoverlay, false);
  doneButton = getPref("internal.doneButton", "bool", 
		getPref("global.doneButton", "bool", false));
  doneAuto = getPref("internal.doneAutoSubscribe", "bool", 
		getPref("global.doneAutoSubscribe", "bool", false));
  if (!doneButton) newsfoxdoButton(event);
	if (!doneAuto && gFF >= 2) addAutoSubscribe();
	UninstallObserver.register();
}

function unregister(event)
{
	if (!gKMeleon) UninstallObserver.unregister();
}

function addAutoSubscribe()
{
	// following 'appropriate' method doesn't handle chrome://
	// FF bug#391286
	// navigator.registerContentHandler("application/vnd.mozilla.maybe.feed", NF_ADDURI, "Newsfox");
	var feedUri = new Array();
	for (var i=0; i<=AUTOSIZE; i++)
	{
		feedUri[i] = getPref("browser.contentHandlers.types." + i + ".uri", "str", "",true);
		if (feedUri[i] == NF_ADDURI) return;
	}
	var i=2;
	var done = false;
	while (!done && i <= AUTOSIZE)
		if (feedUri[++i] == "chrome://browser-region/locale/region.properties") done = true;
	if (done)
	{
		setPref("browser.contentHandlers.types." + i + ".title", "str", "NewsFox",true);
		setPref("browser.contentHandlers.types." + i + ".uri", "str", NF_ADDURI,true);
		setPref("browser.contentHandlers.types." + i + ".type", "str", "application/vnd.mozilla.maybe.feed",true);
  	setPref("internal.doneAutoSubscribe", "bool", true);
	}
	else
	{
		alert("Problem setting NewsFox in autosubscribe due to Firefox bug#391286.\nVote to fix this Firefox bug (need bugzilla.mozilla account)\nhttps://bugzilla.mozilla.org/votes.cgi?action=show_user&bug_id=391286#vote_391286");
  	setPref("internal.doneAutoSubscribe", "bool", true);
	}
//	setPref("browser.contentHandlers.auto.application/vnd.mozilla.maybe.feed","str",NF_ADDURI,true);
//	setPref("browser.feeds.handlers.webservice","str",NF_ADDURI,true);
}

function newsfoxdoButton(event)
{
  var mbar = document.getElementById(NF_MENUBAR);
  var nbar = document.getElementById(NF_NAVBAR);
	if (!nbar) nbar = document.getElementById(NF_NAVBAR_NEW);
  
	var done = false;
	if (nbar.collapsed == true && mbar && mbar.collapsed == true) done = true;
	if ("currentSet" in nbar && nbar.currentSet.indexOf("newsfox-button") > -1) done = true;
	if (mbar && mbar.currentSet.indexOf("newsfox-button") > -1) done = true;
	if (done)
	{
    setPref("internal.doneButton", "bool", true);
    return;
  }

  var newSet = "";

  if (nbar.collapsed == false && "currentSet" in nbar && nbar.currentSet != "__empty") {
    var homeButton = nbar.currentSet.indexOf("home-button");
    if (homeButton > -1)
      newSet = nbar.currentSet.substring(0,homeButton+11) + ",newsfox-button" + nbar.currentSet.substring(homeButton+11,nbar.currentSet.length);
    else {
      var urlbarContainer = nbar.currentSet.indexOf("urlbar-container");
      if (urlbarContainer > -1)
        newSet = nbar.currentSet.substring(0,urlbarContainer) + "newsfox-button," + nbar.currentSet.substring(urlbarContainer,nbar.currentSet.length);
    }
    if (newSet == "")
      newSet = "newsfox-button," + nbar.currentSet;
    nbar.setAttribute("currentset", newSet);
    nbar.currentSet = newSet;
    document.persist(NF_NAVBAR, "currentset");
  }
  else if (mbar) {  // put it on menubar
    var homeButton = mbar.currentSet.indexOf("home-button");
    if (homeButton > -1)
      newSet = mbar.currentSet.substring(0,homeButton+11) + ",newsfox-button" + mbar.currentSet.substring(homeButton+11,mbar.currentSet.length);
    else {
      var menubarItems = mbar.currentSet.indexOf("menubar-items");
      if (menubarItems > -1)
        newSet = mbar.currentSet.substring(0,menubarItems+13) + ",newsfox-button" + mbar.currentSet.substring(menubarItems+13,mbar.currentSet.length);
      else { 
        if (mbar.currentSet != "__empty")
          newSet = mbar.currentSet + ",newsfox-button";
      }
    }
    if (newSet != "") {
      mbar.setAttribute("currentset", newSet);
      mbar.currentSet = newSet;
      document.persist(NF_MENUBAR, "currentset");
    }
  }
  try {BrowserToolboxCustomizeDone(true);} catch (e) {}
  setPref("internal.doneButton", "bool", true);
}

function openNewsfox(newTab)
{
	var nT = getPref("z.buttonOpensNewTab", "bool", false);
	if (nT) newTab = !newTab;
	var tabbrowser = window.gBrowser;
  var tabs = tabbrowser.tabContainer.childNodes;
  var tab;
  for (var i = 0; i < tabs.length; ++i) {
    tab = tabs[i];
    var browser = tabbrowser.getBrowserForTab(tab);
		if("chrome://newsfox/content/newsfox.xul" == browser.contentDocument.location)
		{
			tabbrowser.selectedTab = tab;
			return;
		}
	}
	// if we got to this point, it means that no NewsFox in current window. Try to search other windows if any.

	var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                   .getService(Components.interfaces.nsIWindowMediator);
	var enumerator = wm.getEnumerator("navigator:browser");
	while(enumerator.hasMoreElements())
	{
	  var win = enumerator.getNext();
  	// |win| is [Object ChromeWindow] (just like |window|), do something with it
		tabbrowser = win.gBrowser;
	  tabs = tabbrowser.tabContainer.childNodes;
	  for (var i = 0; i < tabs.length; ++i) {
	    tab = tabs[i];
	    var browser = tabbrowser.getBrowserForTab(tab);
			if("chrome://newsfox/content/newsfox.xul" == browser.contentDocument.location)
			{
				// some problems with raising, so we close it to re-open after in current window
				browser.loadURI("about:blank", null, null); // if there is only one tab it'll not be removed. So, we change the browser location to save feeds
				tabbrowser.removeTab(tab);
			}
  	}
	}
	// Now we sure that no NewsFox is opened. Starting one.
	if (newTab) {
		getBrowser().selectedTab = getBrowser().addTab("chrome://newsfox/content/newsfox.xul")
	} else {
		getBrowser().loadURI("chrome://newsfox/content/newsfox.xul", null, null);
	}
}

// from http://xulsolutions.blogspot.com/2006/07/creating-uninstall-script-for.html
var UninstallObserver =
{
	_uninstall : false,

	observe : function(subject, topic, data)
	{
		if (topic == "em-action-requested")
		{
			subject.QueryInterface(Components.interfaces.nsIUpdateItem);

			if (subject.id == MY_EXTENSION_UUID)
			{
				if (data == "item-uninstalled")
					this._uninstall = true;
				else if (data == "item-cancel-action")
					this._uninstall = false;
			}
		}
		else if (topic == "quit-application-granted")
		{
			if (this._uninstall) this.cleanup();
			this.unregister();
		}
	},

	register : function()
	{
//		var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
//                   .getService(Components.interfaces.nsIWindowMediator);
//		var enumerator = wm.getEnumerator("navigator:browser");
//		var index = 0;
//		while(enumerator.hasMoreElements())
//		{
//			enumerator.getNext();
//			index++;
//		}
//		if (index > 1) return;  // only register observer for first window

		var observerService =
				Components.classes["@mozilla.org/observer-service;1"].
				getService(Components.interfaces.nsIObserverService);

		observerService.addObserver(this, "em-action-requested", false);
		observerService.addObserver(this, "quit-application-granted", false);
	},

	unregister : function()
	{
  	var observerService =
				Components.classes["@mozilla.org/observer-service;1"].
				getService(Components.interfaces.nsIObserverService);

		observerService.removeObserver(this,"em-action-requested");
		observerService.removeObserver(this,"quit-application-granted");
	},

	cleanup : function()
	{
		const NF_SB = document.getElementById("newsfox-string-bundle");
		if (window.confirm(NF_SB.getString('uninstallDeleteFilesPrefs')))
		{
			try
			{
    		var file = getProfileDir();
    		if (file.exists()) file.remove(true);
			}
			catch(e) { alert(NF_SB.getString('uninstallUnableFiles')); }
			try
			{
				var nsIPref =
						Components.classes["@mozilla.org/preferences;1"]
						.getService(Components.interfaces.nsIPref);
				var branch = nsIPref.getBranch("newsfox.");
				branch.deleteBranch("");
				for (var i=0; i<=AUTOSIZE; i++)
				{
					var feedUri = getPref("browser.contentHandlers.types." + i + ".uri", "str", "",true);
					if (feedUri == NF_ADDURI)
					{
						branch = nsIPref.getBranch("browser.contentHandlers.types." + i + ".");
						branch.deleteBranch("");
					}
				}
				var handlerUri = getPref("browser.contentHandlers.auto.application/vnd.mozilla.maybe.feed", "str", "",true);
				if (handlerUri == NF_ADDURI)
					nsIPref.getBranch("browser.contentHandlers.auto.application/vnd.mozilla.maybe.feed").deleteBranch("");
				handlerUri = getPref("browser.feeds.handlers.webservice", "str", "",true);
				if (handlerUri == NF_ADDURI)
					nsIPref.getBranch("browser.feeds.handlers.webservice").deleteBranch("");
			}
			catch(e) { alert(NF_SB.getString('uninstallUnablePrefs')); }
		}
	}
}

function setCSS()
{
	var file = getProfileDir();
	file.append("newsfox.css");
	if (file.exists())
	{
		var sss = Components.classes["@mozilla.org/content/style-sheet-service;1"]
						.getService(Components.interfaces.nsIStyleSheetService);
		var ios = Components.classes["@mozilla.org/network/io-service;1"]
						.getService(Components.interfaces.nsIIOService);
		var uri = ios.newURI(getFileSpec(file), null, null);
		if(!sss.sheetRegistered(uri, sss.USER_SHEET))
  		sss.loadAndRegisterSheet(uri, sss.USER_SHEET);
	}
}

window.addEventListener('load', initoverlay, false);
window.addEventListener('unload', unregister, false);

