/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *   Ron Pruitt <wa84it@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var blurring;

function init()
{
	const NF_SB = document.getElementById("newsfox-string-bundle");
  var url        = window.arguments[0].url;
  var style      = window.arguments[0].style;
  var deleteOld  = window.arguments[0].deleteOld;
  var autoCheck  = window.arguments[0].autoCheck;
  var iconsrc    = window.arguments[0].iconsrc;
  var groupstr   = window.arguments[0].groupstr;
  var groupmemb  = window.arguments[0].groupmemb;
	var daysToKeep = window.arguments[0].daysToKeep;

	checkLocalPng("fOlivemark","livemark.png","src");
	checkLocalPng("fOhome","home.png","src");
  document.getElementById("cbiconsrc").src = iconsrc;
  var urlbox = document.getElementById("url");
  urlbox.value = url;
  var list = document.getElementById("style");
  list.selectedIndex = style;
  document.getElementById("cbDeleteOld").checked = deleteOld;
  document.getElementById("cbAutoCheck").checked = autoCheck;
  document.getElementById("cbDontDeleteUnread").checked = window.arguments[0].dontDeleteUnread;
  document.getElementById("cbDontDeleteUnread").disabled = !deleteOld;
  document.getElementById("cbKeep").checked = (daysToKeep > -1);
  document.getElementById("cbKeep").disabled = !deleteOld;
  document.getElementById("cbKeep").label = NF_SB.getString('deleteOld.del3');
  document.getElementById("cbKeepAfter").value = NF_SB.getString('deleteOld.del.after');
	var dK = daysToKeep;
	if (dK == -1) dK = "";
  document.getElementById("cbDaysToKeep").value = dK;
	onCheckKeep();
  document.getElementById("cbPrivate").checked = window.arguments[0].prvate;
  document.getElementById("username").value = window.arguments[0].username;
  document.getElementById("password").value = window.arguments[0].password;
	document.getElementById("refreshCaption").label = NF_SB.getString('lastRefresh') + " " + displayDate(window.arguments[0].lastUpdate,2);
	document.getElementById("cbAutoRefresh").checked = (window.arguments[0].autoRefreshInterval != 0);
	cbAutoRefreshOnCommand();
	document.getElementById("autoRefreshInterval").value = window.arguments[0].autoRefreshInterval;

  var namebox = document.getElementById("Name");
  var homebox = document.getElementById("Homepage");
  var grplist = document.getElementById("grplist");
	if (window.arguments[0].storage)
	{
		document.getElementById("feedOptionsDlg").buttons = "accept,cancel";
		document.getElementById("storageH1").hidden = true;
		document.getElementById("cbiconsrc").src = ICON_STORAGE;
		document.getElementById("storageH2").hidden = true;
		document.getElementById("storageH3").hidden = true;
		document.getElementById("storageH4").hidden = true;
		document.getElementById("authGroupbox").hidden = true;
		if (window.arguments[0].isNew)
    	namebox.value = NF_SB.getString('newStorageFeed');
		else
    	namebox.value = window.arguments[0].name;
		namebox.selected = true;
	}
  else if (window.arguments[0].isNew)
  {
    var msg = NF_SB.getString('feedfills');
    namebox.value = msg;
    namebox.disabled = true;
    homebox.value = msg;
    homebox.disabled = true;
    urlbox.selected = true;
    var feedOptDlg = document.getElementById("feedOptionsDlg");
    feedOptDlg.defaultButton = "disclosure";
  }
  else
  {
    namebox.value = window.arguments[0].name;
    homebox.value = window.arguments[0].homepage;
  }
	if (url.substring(0,5) != "https")
		document.getElementById("authGroupbox").hidden = true;

  var names = new Array();
  names = groupstr.split(",");
  var membs = new Array();
  membs = groupmemb.split(",");

  var index = 0;
  while (names.length >= 1)
  {
		var name = names.shift();
		var memb = membs.shift();
		var tmp = document.createElement("listitem");
		tmp.setAttribute("type","checkbox");
		if (memb & 0x02) tmp.setAttribute("style","color: blue");
		if (memb & 0x01) tmp.setAttribute("checked",true);
		if (memb & 0x04) tmp.setAttribute("hidden",true);
		if (index == 0) tmp.setAttribute("disabled",true);
    tmp.setAttribute("label",name);
    if (name.length > 20) tmp.setAttribute("tooltiptext",name);
		tmp.setAttribute("id","nwsfx"+index);
    grplist.appendChild(tmp);
		index++;
  }
	blurring = false;
}

function doCheckFeed()
{
  window.arguments[0].checkFeed = true;
  var feedOptDlg = document.getElementById("feedOptionsDlg");
  feedOptDlg.acceptDialog();
}

function doAccept()
{
	const NF_SB = document.getElementById("newsfox-string-bundle");
	if (window.arguments[0].storage)
	{
  	var namebox = document.getElementById("Name");
		if (namebox.value == "")
		{
    	namebox.value = NF_SB.getString('newStorageFeed');
			namebox.select();
			namebox.focus();
			return false;
		}
	}
	else
	{
	  var elem = document.getElementById("url");
	  window.arguments[0].url = elem.value;
		var oldFeed = window.arguments[0].model.getFeedByURL(elem.value);
		var uid = window.arguments[0].uid;
		if (window.arguments[0].isNew && oldFeed != null && oldFeed.uid != uid)
		{
			if (oldFeed.exclude)
				window.arguments[0].model.remove(oldFeed);
			else
			{
				alert("'" + oldFeed.getDisplayName() + "' " + NF_SB.getString('alert.feedExists'));
				window.arguments[0].checkFeed = false;
		  	var urlbox = document.getElementById("url");
				urlbox.select();
				urlbox.focus();
				return false;
			}
		}
	}

  window.arguments[0].ok = true;
	window.arguments[0].name = document.getElementById("Name").value;
	window.arguments[0].iconsrc = document.getElementById("cbiconsrc").src;
	window.arguments[0].homepage = document.getElementById("Homepage").value;

  elem = document.getElementById("style");
  window.arguments[0].style = parseInt(elem.value);

  elem = document.getElementById("cbDeleteOld");
  window.arguments[0].deleteOld = elem.checked;

	elem = document.getElementById("autoRefreshInterval").value;
	window.arguments[0].autoRefreshInterval = elem;
  elem = document.getElementById("cbAutoCheck");
  window.arguments[0].autoCheck = elem.checked;

	window.arguments[0].dontDeleteUnread = document.getElementById("cbDontDeleteUnread").checked;
	window.arguments[0].daysToKeep = !document.getElementById("cbKeep").checked ? -1 : document.getElementById("cbDaysToKeep").value;
	window.arguments[0].prvate = document.getElementById("cbPrivate").checked;
	window.arguments[0].username = document.getElementById("username").value;
	window.arguments[0].password = document.getElementById("password").value;

  var membs = new Array();
  var elem = document.getElementById("nwsfx0");
  var index = 0;
  while (elem != null)
  {
    membs.push(1*(elem.checked));
    index++;
    elem = document.getElementById("nwsfx"+index);
  }
  window.arguments[0].groupmemb = membs.join();
  return true;
}

function onDeleteOldCommand()
{
	document.getElementById("cbDontDeleteUnread").disabled = !document.getElementById("cbDeleteOld").checked;
	document.getElementById("cbKeep").disabled = !document.getElementById("cbDeleteOld").checked;
	onCheckKeep();
}

function onCheckKeep()
{
  document.getElementById("cbDaysToKeep").disabled = !document.getElementById("cbKeep").checked || document.getElementById("cbKeep").disabled;
}

function toggleIcon()
{
	var iconsrc = document.getElementById("cbiconsrc").src;
	var uid = window.arguments[0].uid;
	var file = getProfileDir();
	var leafName = uid + ".ico";
	file.append(leafName);
	if (iconsrc == ICON_OK)
	{
		var nsIFilePicker = Components.interfaces.nsIFilePicker;
		var pickfile = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
		const NF_SB = document.getElementById("newsfox-string-bundle");
		pickfile.init(window, NF_SB.getString('chooseicon'), nsIFilePicker.modeOpen);
		pickfile.displayDirectory = getProfileDir();
		pickfile.appendFilters(nsIFilePicker.filterImages);
		pickfile.appendFilters(nsIFilePicker.filterAll);
		var filepicked = pickfile.show();
		if (filepicked == nsIFilePicker.returnOK)
		{
			if (file.exists()) file.remove(false);
			pickfile.file.copyTo(getProfileDir(),leafName);
			iconsrc = getFileSpec(file) + "?" + (new Date()).getTime();
			document.getElementById("cbiconsrc").src = iconsrc;
		}
	}
	else  // has an icon, change to ICON_OK
	{
		document.getElementById("cbiconsrc").src = ICON_OK;
		if (file.exists()) file.remove(false);
	}
}

function feedChange()
{
	if (blurring) return;
	blurring = true;
  var url = document.getElementById("url").value;
	var authGroupbox = document.getElementById("authGroupbox");
	if (url.substring(0,5) != "https")
		authGroupbox.hidden = true;
	else
		authGroupbox.removeAttribute("hidden");
// FF3 bugs, #392417, #371508: sizeToContent() broken, seems to work
// with an assignment statement intervening between resizing event
	blurring = false;
	sizeToContent();
	return true;
}

function cbAutoRefreshOnCommand()
{
	var aRI = document.getElementById("autoRefreshInterval");
	aRI.disabled = !document.getElementById("cbAutoRefresh").checked;
	if (!document.getElementById("cbAutoRefresh").checked) aRI.value = 0;
}

function autoInterval()
{
	var aRI = document.getElementById("autoRefreshInterval");
	if (aRI.value < MINFEEDTIME)
	{
		aRI.value = MINFEEDTIME;
		const NF_SB = document.getElementById("newsfox-string-bundle");
		alert(NF_SB.getString('autoCheckIntervalWarning'));
	}
}
