/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *   Ron Pruitt <wa84it@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const VERSION = "1.0";
const NEWSFOX = "NewsFox";
const NEWSFOX_RSS = "http://newsfox.mozdev.org/rss/rss.xml?startup";
const NEWSFOX_DATE = "April 15, 2003 8:01 PM";
const NF_URI = "chrome://newsfox/content/newsfox.xul?bkmk";
const LONG_DATE_STYLE = 2;
const ERROR_OK = "0";
const ERROR_INVALID_FEED_URL = "1";
const ERROR_UNKNOWN_FEED_FORMAT = "2";
const ERROR_SERVER_ERROR = "3";
const ERROR_NOT_FOUND = "4";
const FEED_VALIDATOR = "http://validator.w3.org/feed/check.cgi?url=";
const NO_LINK = "";
const ICON_OK = getPng("feed.png");
const ICON_STORAGE = getPng("storage.png");
const MASTER = "master";
const MASTER_GROUP = "master_group";
const MASTER_INDEX = "master_index";
const MASTER_FILTER = "master_filter";

const HRS12 = 1000*60*60*12;
const DATEBASE = -HRS12;
const TOP_NO_DATE = new Date(DATEBASE + HRS12);
const NO_DATE = new Date(DATEBASE);
const TOP_INVALID_DATE = new Date(DATEBASE - HRS12);
const INVALID_DATE = new Date(DATEBASE - 2*HRS12);
const TOP_FUTURE_DATE = new Date(DATEBASE - 3*HRS12);

const MINAUTOTIME = 5;
const MINFEEDTIME = 10;

var gKMeleon = false;
var gEMusic = false;
var gFF = -1;
var gNewsfoxDirURL = null;
var gMsgDone = false;
var gSdr;
var gTag = "";
var gAllFeedsLoaded = false;
var gLoadFlags = 0;

// spam filter
var gGoodArray = new Array();
var gTotalArray = new Array();
var gWordArray = new Array();
const S_TOTAL_START = 1000;
const S_GOOD_START = 500;
const S_MULT = 0.99;
const S_MINCOUNT = 2500;
const S_MINWORDLENGTH = 3;
const S_MAXCOMPARE = 30;
const S_UNREADPCT = 0.75;
const S_MAXWORDS = 2500;
const S_MINWORDTOTAL = 1000;
const S_MINWORDS = 1000;
var gArtsToUpdateSpam = new Array();
var gArtsToAddSpam = new Array();
var gArtsToScoreSpam = new Array();
const S_BIGNUM = 1000111000111;
const S_BIGNUMDIV = 1000000;
const S_MAX_ARTS = 200;
const S_NEW_DAYS = 1;

function sortPair()
{
	this.colId = null;
	this.dir = null;
}

/**
 * Get the newsfox directory 
 */

function getProfileDir()
{
	var nsIPH = Components.classes["@mozilla.org/network/protocol;1?name=file"].createInstance(Components.interfaces.nsIFileProtocolHandler);
	const NF_SB = document.getElementById("newsfox-string-bundle");
	var profURL = getPref("global.directory", "str", "");
	if (gNewsfoxDirURL != null)  // use it, but warn if preference changed
	{
		if (gNewsfoxDirURL != profURL && !gMsgDone)
		{
			alert(NF_SB.getString('inuse'));
			gMsgDone = true;
		}
		return nsIPH.getFileFromURLSpec(gNewsfoxDirURL);
	}
	if (profURL != "")  // use it if exists, otherwise choose new
	{
		var file = nsIPH.getFileFromURLSpec(profURL);
		if (file.exists())
		{
			gNewsfoxDirURL = profURL;
			return nsIPH.getFileFromURLSpec(gNewsfoxDirURL);
		}

		var msg = NF_SB.getString('confirm.newNewsfoxDir');
		if (window.confirm(msg))  // pick new directory, else use default
		{
			var picker = nfDirPicked(file);
			if (picker)
			{
				gNewsfoxDirURL = nsIPH.getURLSpecFromFile(picker.file);
				setPref("global.directory", "str", gNewsfoxDirURL);
				return picker.file;
			}
		}
	}

	// default to standard location
  var file = Components.classes["@mozilla.org/file/directory_service;1"].
    getService(Components.interfaces.nsIProperties).
    get("ProfD", Components.interfaces.nsIFile);
  file.append("newsfox");
  if (!file.exists()) file.create(0x01, 0750);
	gNewsfoxDirURL = nsIPH.getURLSpecFromFile(file);
	setPref("global.directory", "str", gNewsfoxDirURL);
	return file;
}

function nfDirPicked(startFile)
{
	var picker = Components.classes["@mozilla.org/filepicker;1"].
		createInstance(Components.interfaces.nsIFilePicker);
	var file = startFile;
	try
	{
		while (!file.exists() || file.isFile()) file = file.parent;
		picker.displayDirectory = file;
	}
	catch(e){}
	const NF_SB = document.getElementById("newsfox-string-bundle");
	var wintitle = NF_SB.getString('chooseNewsfoxFolder');
	picker.init(window, wintitle, picker.modeGetFolder);
	if(picker.show() == picker.returnOK) return picker;
	else return null;
}

function getPref(name, type, dfault, notNewsfox)
{
	var base = "newsfox.";
	if (notNewsfox) base = "";
	var prefs = Components.classes["@mozilla.org/preferences-service;1"]
		.getService(Components.interfaces.nsIPrefService)
		.getBranch(base);

	if (prefs.getPrefType(name) == prefs.PREF_INVALID) return dfault;
	try
	{
		switch (type)
		{
			case "str":
				return prefs.getCharPref(name);
				break;
			case "int":
				return prefs.getIntPref(name);
				break;
			case "bool":
				return prefs.getBoolPref(name);
				break;
		}
		return null;
	}
	catch(e) { return dfault; }
}

function setPref(name, type, value, notNewsfox)
{
	var base = "newsfox.";
	if (notNewsfox) base = "";
	var prefs = Components.classes["@mozilla.org/preferences-service;1"]
		.getService(Components.interfaces.nsIPrefService)
		.getBranch(base);

	switch (type)
	{
		case "str":
			prefs.setCharPref(name,value);
			break;
		case "int":
			prefs.setIntPref(name,value);
			break;
		case "bool":
			prefs.setBoolPref(name,value);
			break;
	}
}

String.prototype.trim = function()
{
	return this.replace(/^\s+|\s+$/g, '');
}

function setTitle()
{
	newTitle(gFdGroup[0].getUnread());
}

function newTitle(undone)
{
	var nF = NEWSFOX;
	if (undone > 0) nF += " (" + undone + ")";
	// prevent flicker, only redo if needed
	if (document.title != nF) document.title = nF;
}

function getPng(Pngfile)
{
	var nsIPH = Components.classes["@mozilla.org/network/protocol;1?name=file"].createInstance(Components.interfaces.nsIFileProtocolHandler);
	var profURL = getPref("global.directory", "str", "");
	if (profURL != "")
	{
		var file = nsIPH.getFileFromURLSpec(profURL);
		if (file.exists())
		{
			file.append("images");
			file.append(Pngfile);
			if (file.exists()) return getFileSpec(file);
		}
	}
	return "chrome://newsfox/skin/images/"+Pngfile;
}

function checkLocalPng(id,png,prop)
{
	if (!prop) prop = "image";
	var localPng = getPng(png);
	if (localPng.charAt(0) == "f")  // local "f"ile
		document.getElementById(id).setAttribute(prop, localPng);
}

function displayDate(date, style)
{
	const NF_SB = document.getElementById("newsfox-string-bundle");
	if (date > TOP_NO_DATE)
	{
		if (style == 2)
			return date.toLocaleString();
		else if (style == 0)
		{
			var hour = date.getHours();
			if (hour < 10) hour = "0" + hour;
			var min = date.getMinutes();
			if (min < 10) min = "0" + min;
			var time = hour + ":" + min;
			var dat = date.getFullYear() + "-" + (date.getMonth()+1) + "-" + date.getDate() + " ";
			var now = new Date();
			var nowdat = now.getFullYear() + "-" + (now.getMonth()+1) + "-" + now.getDate() + " ";
			if (dat == nowdat) dat = "";
			return (dat + time);
		}
		else  // style == 1
		{
			var sdf =  Components.classes["@mozilla.org/intl/scriptabledateformat;1"]
				.createInstance(Components.interfaces.nsIScriptableDateFormat);
			return sdf.FormatDateTime("", sdf.dateFormatShort,
				sdf.timeFormatNoSeconds, date.getFullYear(), date.getMonth()+1,
				date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
		}
	}
	else if (date <= TOP_FUTURE_DATE) return NF_SB.getString('FUTURE_DATE');
	else if (date <= TOP_INVALID_DATE) return NF_SB.getString('INVALID_DATE');
	else return NF_SB.getString('NO_DATE');
}

function setUserAgent()
{
	if (navigator.userAgent.indexOf('eMusic') > -1)
		{ gKMeleon = true; gEMusic = true; }
	else if (navigator.userAgent.indexOf('K-Meleon') > -1) gKMeleon = true;
	else if (navigator.userAgent.indexOf('Firefox\/2') > -1) gFF = 2;
	else if (navigator.userAgent.indexOf('Firefox\/3') > -1 || navigator.userAgent.indexOf('GranParadiso') > -1 || navigator.userAgent.indexOf('Minefield') > -1) gFF = 3;
}

function getFileSpec(file)
{
	var nsIPH = Components.classes["@mozilla.org/network/protocol;1?name=file"].createInstance(Components.interfaces.nsIFileProtocolHandler);
	return nsIPH.getURLSpecFromFile(file);
}

function xmlLoad(filespec)
{
	var req = new XMLHttpRequest();
	req.open("GET", filespec, false);
	req.overrideMimeType("application/xml");
	req.send(null);
	return req.responseXML;
}
